/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.junit;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.zuchini.junit.DescriptionHelper;
import org.zuchini.junit.OutlineRunner;
import org.zuchini.junit.SimpleScenarioRunner;
import org.zuchini.junit.SteppedScenarioRunner;
import org.zuchini.junit.description.AnnotationHandler;
import org.zuchini.junit.description.FeatureInfo;
import org.zuchini.runner.Context;
import org.zuchini.runner.FeatureStatement;
import org.zuchini.runner.OutlineStatement;
import org.zuchini.runner.ScenarioStatement;
import org.zuchini.runner.SimpleScenarioStatement;

class FeatureRunner
extends ParentRunner<Runner> {
    private final FeatureStatement featureStatement;
    private final List<Runner> children;
    private final Description description;

    public FeatureRunner(Class<?> testClass, Context context, FeatureStatement featureStatement, boolean reportIndividualSteps) throws InitializationError {
        super(testClass);
        this.featureStatement = featureStatement;
        this.children = FeatureRunner.buildChildren(testClass, context, featureStatement, reportIndividualSteps);
        this.description = DescriptionHelper.createFeatureDescription(testClass, featureStatement.getFeature(), this.children, this.getRunnerAnnotations());
    }

    private static List<Runner> buildChildren(Class<?> testClass, Context context, FeatureStatement featureStatement, boolean reportIndividualSteps) throws InitializationError {
        List scenarios = featureStatement.getScenarios();
        ArrayList<Runner> children = new ArrayList<Runner>(scenarios.size());
        for (ScenarioStatement scenario : scenarios) {
            if (scenario instanceof OutlineStatement) {
                children.add((Runner)new OutlineRunner(testClass, context, featureStatement, (OutlineStatement)scenario, reportIndividualSteps));
                continue;
            }
            if (scenario instanceof SimpleScenarioStatement) {
                if (reportIndividualSteps) {
                    children.add(new SteppedScenarioRunner(testClass, context, featureStatement, (SimpleScenarioStatement)scenario));
                    continue;
                }
                children.add(new SimpleScenarioRunner(testClass, context, featureStatement, (SimpleScenarioStatement)scenario));
                continue;
            }
            throw new IllegalStateException("Unknown scenario type [" + scenario.getClass().getName() + "]");
        }
        return children;
    }

    protected Annotation[] getRunnerAnnotations() {
        return new Annotation[]{AnnotationHandler.create(FeatureInfo.class, this.featureStatement.getFeature())};
    }

    public Description getDescription() {
        return this.description;
    }

    protected List<Runner> getChildren() {
        return this.children;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }
}

