/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.junit;

import java.lang.annotation.Annotation;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.zuchini.junit.DescriptionHelper;
import org.zuchini.junit.description.AnnotationHandler;
import org.zuchini.junit.description.FeatureInfo;
import org.zuchini.junit.description.ScenarioInfo;
import org.zuchini.runner.Context;
import org.zuchini.runner.FeatureStatement;
import org.zuchini.runner.Scope;
import org.zuchini.runner.SimpleScenarioStatement;

class SimpleScenarioRunner
extends Runner {
    private final Class<?> testClass;
    private final Context context;
    private final FeatureStatement featureStatement;
    private final SimpleScenarioStatement scenarioStatement;
    private final Description description;

    public SimpleScenarioRunner(Class<?> testClass, Context context, FeatureStatement featureStatement, SimpleScenarioStatement scenarioStatement) throws InitializationError {
        this.testClass = testClass;
        this.context = context;
        this.featureStatement = featureStatement;
        this.scenarioStatement = scenarioStatement;
        this.description = DescriptionHelper.createScenarioDescription(testClass, scenarioStatement.getScenario(), this.getRunnerAnnotations());
    }

    private Annotation[] getRunnerAnnotations() {
        return new Annotation[]{AnnotationHandler.create(FeatureInfo.class, this.featureStatement.getFeature()), AnnotationHandler.create(ScenarioInfo.class, this.scenarioStatement.getScenario())};
    }

    public Description getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        Scope scenarioScope = this.context.getScenarioScope();
        scenarioScope.begin();
        try {
            notifier.fireTestStarted(this.description);
            this.scenarioStatement.evaluate(this.context);
        }
        catch (AssumptionViolatedException ex) {
            notifier.fireTestAssumptionFailed(new Failure(this.description, (Throwable)ex));
        }
        catch (Throwable throwable) {
            notifier.fireTestFailure(new Failure(this.description, throwable));
        }
        finally {
            notifier.fireTestFinished(this.description);
            scenarioScope.end();
        }
    }

    public int testCount() {
        return 1;
    }
}

