/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.junit;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.zuchini.junit.DescriptionHelper;
import org.zuchini.junit.description.AnnotationHandler;
import org.zuchini.junit.description.FeatureInfo;
import org.zuchini.junit.description.ScenarioInfo;
import org.zuchini.junit.description.StepInfo;
import org.zuchini.model.Step;
import org.zuchini.runner.Context;
import org.zuchini.runner.FeatureStatement;
import org.zuchini.runner.HookStatement;
import org.zuchini.runner.Scope;
import org.zuchini.runner.SimpleScenarioStatement;
import org.zuchini.runner.Statement;
import org.zuchini.runner.StepStatement;

class SteppedScenarioRunner
extends Runner {
    private final Class<?> testClass;
    private final Context context;
    private final FeatureStatement featureStatement;
    private final SimpleScenarioStatement scenarioStatement;
    private final List<DescribedStepStatement> children;
    private final Description description;

    public SteppedScenarioRunner(Class<?> testClass, Context context, FeatureStatement featureStatement, SimpleScenarioStatement scenarioStatement) throws InitializationError {
        this.testClass = testClass;
        this.context = context;
        this.featureStatement = featureStatement;
        this.scenarioStatement = scenarioStatement;
        this.children = this.buildChildren();
        this.description = DescriptionHelper.createScenarioDescription(testClass, scenarioStatement.getScenario(), this.children, this.getRunnerAnnotations());
    }

    private List<DescribedStepStatement> buildChildren() {
        List steps = this.scenarioStatement.getSteps();
        ArrayList<DescribedStepStatement> result = new ArrayList<DescribedStepStatement>(steps.size());
        for (StepStatement stepStatement : steps) {
            Step step = stepStatement.getStep();
            result.add(new DescribedStepStatement(stepStatement, DescriptionHelper.createStepDescription(this.testClass, step, this.getStepAnnotations(step))));
        }
        return result;
    }

    private Annotation[] getStepAnnotations(Step step) {
        return new Annotation[]{AnnotationHandler.create(FeatureInfo.class, this.featureStatement.getFeature()), AnnotationHandler.create(ScenarioInfo.class, this.scenarioStatement.getScenario()), AnnotationHandler.create(StepInfo.class, step)};
    }

    private Annotation[] getRunnerAnnotations() {
        return new Annotation[]{AnnotationHandler.create(FeatureInfo.class, this.featureStatement.getFeature()), AnnotationHandler.create(ScenarioInfo.class, this.scenarioStatement.getScenario())};
    }

    public Description getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        Scope scenarioScope = this.context.getScenarioScope();
        scenarioScope.begin();
        try {
            Iterator<DescribedStepStatement> it = this.children.iterator();
            boolean first = true;
            try {
                while (it.hasNext()) {
                    DescribedStepStatement describedStepStatement = it.next();
                    Description stepDescription = describedStepStatement.getDescription();
                    StepStatement stepStatement = describedStepStatement.getStepStatement();
                    try {
                        notifier.fireTestStarted(stepDescription);
                        if (first) {
                            for (HookStatement hook : this.scenarioStatement.getBeforeHooks()) {
                                this.evaluate(notifier, (Statement)hook, stepDescription);
                            }
                            first = false;
                        }
                        this.evaluate(notifier, (Statement)stepStatement, stepDescription);
                        boolean last = !it.hasNext();
                        if (!last) continue;
                        for (HookStatement hook : this.scenarioStatement.getAfterHooks()) {
                            this.evaluate(notifier, (Statement)hook, stepDescription);
                        }
                    }
                    finally {
                        notifier.fireTestFinished(stepDescription);
                    }
                }
            }
            catch (IgnoreRemainingStepsException e) {
                while (it.hasNext()) {
                    DescribedStepStatement describedStepStatement = it.next();
                    Description stepDescription = describedStepStatement.getDescription();
                    notifier.fireTestIgnored(stepDescription);
                }
            }
        }
        finally {
            scenarioScope.end();
        }
    }

    private void evaluate(RunNotifier notifier, Statement statement, Description description) throws IgnoreRemainingStepsException {
        try {
            statement.evaluate(this.context);
        }
        catch (AssumptionViolatedException ex) {
            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)ex));
            throw IgnoreRemainingStepsException.INSTANCE;
        }
        catch (Throwable throwable) {
            notifier.fireTestFailure(new Failure(description, throwable));
            throw IgnoreRemainingStepsException.INSTANCE;
        }
    }

    public int testCount() {
        return this.scenarioStatement.getSteps().size();
    }

    static class DescribedStepStatement
    implements Describable {
        private final StepStatement stepStatement;
        private final Description description;

        DescribedStepStatement(StepStatement stepStatement, Description description) {
            this.stepStatement = stepStatement;
            this.description = description;
        }

        StepStatement getStepStatement() {
            return this.stepStatement;
        }

        public Description getDescription() {
            return this.description;
        }
    }

    static class IgnoreRemainingStepsException
    extends Exception {
        static final IgnoreRemainingStepsException INSTANCE = new IgnoreRemainingStepsException();

        private IgnoreRemainingStepsException() {
        }
    }
}

