/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.junit;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.zuchini.model.Feature;
import org.zuchini.model.Outline;
import org.zuchini.model.Scenario;
import org.zuchini.model.Step;

class DescriptionHelper {
    private DescriptionHelper() {
    }

    private static Description createUniqueDescription(Class<?> runner, String displayName, List<? extends Describable> children, Annotation ... annotations) {
        Description description = children.isEmpty() ? Description.createTestDescription(runner, (String)displayName, (Annotation[])annotations) : Description.createSuiteDescription((String)displayName, (Annotation[])annotations);
        for (Describable describable : children) {
            description.addChild(describable.getDescription());
        }
        return description;
    }

    private static Description createUniqueDescription(Class<?> runner, String uri, int lineNumber, String keyword, String description, List<? extends Describable> children, Annotation ... annotations) {
        String displayName = String.format("%s %s [%s:%d]", keyword, description, uri, lineNumber);
        return DescriptionHelper.createUniqueDescription(runner, displayName, children, annotations);
    }

    static Description createRunnerDescription(Class<?> runner, String displayName, List<? extends Describable> children, Annotation ... annotations) {
        return DescriptionHelper.createUniqueDescription(runner, displayName, children, annotations);
    }

    static Description createFeatureDescription(Class<?> runner, Feature feature, List<? extends Describable> children, Annotation ... annotations) {
        return DescriptionHelper.createUniqueDescription(runner, feature.getUri(), feature.getLineNumber(), feature.getKeyword(), feature.getName(), children, annotations);
    }

    static Description createOutlineDescription(Class<?> runner, Outline outline, List<? extends Describable> children, Annotation ... annotations) {
        return DescriptionHelper.createUniqueDescription(runner, outline.getUri(), outline.getLineNumber(), outline.getKeyword(), outline.getName(), children, annotations);
    }

    static Description createScenarioDescription(Class<?> runner, Scenario scenario, List<? extends Describable> children, Annotation ... annotations) {
        return DescriptionHelper.createUniqueDescription(runner, scenario.getUri(), scenario.getLineNumber(), scenario.getKeyword(), scenario.getName(), children, annotations);
    }

    static Description createScenarioDescription(Class<?> runner, Scenario scenario, Annotation ... annotations) {
        return DescriptionHelper.createScenarioDescription(runner, scenario, Collections.emptyList(), annotations);
    }

    static Description createStepDescription(Class<?> runner, Step step, Annotation ... annotations) {
        return DescriptionHelper.createUniqueDescription(runner, step.getUri(), step.getLineNumber(), step.getKeyword(), step.getName(), Collections.emptyList(), annotations);
    }
}

