/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.junit;

import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.zuchini.junit.DescriptionHelper;
import org.zuchini.junit.description.AnnotationHandler;
import org.zuchini.junit.description.FeatureInfo;
import org.zuchini.junit.description.OutlineInfo;
import org.zuchini.junit.description.ScenarioInfo;
import org.zuchini.runner.Context;
import org.zuchini.runner.FeatureStatement;
import org.zuchini.runner.OutlineStatement;
import org.zuchini.runner.SimpleScenarioStatement;

class SimpleScenarioRunner
extends Runner {
    private final Class<?> testClass;
    private final Context context;
    private final FeatureStatement featureStatement;
    private final SimpleScenarioStatement scenarioStatement;
    @Nullable
    private final OutlineStatement outlineStatement;
    private final Description description;

    public SimpleScenarioRunner(Class<?> testClass, Context context, FeatureStatement featureStatement, SimpleScenarioStatement scenarioStatement, @Nullable OutlineStatement outlineStatement) throws InitializationError {
        this.testClass = testClass;
        this.context = context;
        this.featureStatement = featureStatement;
        this.scenarioStatement = scenarioStatement;
        this.outlineStatement = outlineStatement;
        this.description = DescriptionHelper.createScenarioDescription(testClass, scenarioStatement.getScenario(), this.getRunnerAnnotations());
    }

    private Annotation[] getRunnerAnnotations() {
        Annotation[] annotations = new Annotation[this.outlineStatement == null ? 2 : 3];
        annotations[0] = AnnotationHandler.create(FeatureInfo.class, this.featureStatement.getFeature());
        annotations[1] = AnnotationHandler.create(ScenarioInfo.class, this.scenarioStatement.getScenario());
        if (this.outlineStatement != null) {
            annotations[2] = AnnotationHandler.create(OutlineInfo.class, this.outlineStatement.getOutline());
        }
        return annotations;
    }

    public Description getDescription() {
        return this.description;
    }

    public void run(RunNotifier notifier) {
        try {
            notifier.fireTestStarted(this.description);
            this.scenarioStatement.evaluate(this.context);
        }
        catch (AssumptionViolatedException ex) {
            notifier.fireTestAssumptionFailed(new Failure(this.description, (Throwable)ex));
        }
        catch (Throwable throwable) {
            notifier.fireTestFailure(new Failure(this.description, throwable));
        }
        finally {
            notifier.fireTestFinished(this.description);
        }
    }

    public int testCount() {
        return 1;
    }
}

