/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.junit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.zuchini.junit.DescriptionHelper;
import org.zuchini.junit.FeatureRunner;
import org.zuchini.junit.ZuchiniOptions;
import org.zuchini.runner.Context;
import org.zuchini.runner.FeatureStatement;
import org.zuchini.runner.Scope;
import org.zuchini.runner.World;
import org.zuchini.runner.WorldBuilder;

public class ZuchiniRunnerDelegate
extends ParentRunner<FeatureRunner>
implements Context {
    private final ZuchiniOptions options;
    private final World world;
    private final List<FeatureRunner> children;
    private final Description description;

    public ZuchiniRunnerDelegate(Class<?> testClass, Scope globalScope, Scope scenarioScope) throws InitializationError, IOException {
        super(testClass);
        this.options = testClass.getAnnotation(ZuchiniOptions.class);
        this.world = this.buildWorld(testClass, globalScope, scenarioScope);
        this.children = this.buildChildren(testClass, this.world.getFeatureStatements());
        this.description = DescriptionHelper.createRunnerDescription(testClass, this.getName(), this.children, this.getRunnerAnnotations());
    }

    private List<FeatureRunner> buildChildren(Class<?> testClass, List<FeatureStatement> featureStatements) throws InitializationError {
        boolean reportIndividualSteps = this.options.reportIndividualSteps();
        ArrayList<FeatureRunner> children = new ArrayList<FeatureRunner>(featureStatements.size());
        for (FeatureStatement featureStatement : featureStatements) {
            children.add(new FeatureRunner(testClass, (Context)this.world, featureStatement, reportIndividualSteps));
        }
        return children;
    }

    private World buildWorld(Class<?> testClass, Scope globalScope, Scope scenarioScope) throws IOException {
        List<String> featurePackages = Arrays.asList(this.options.featurePackages());
        List<String> stepDefinitionPackages = Arrays.asList(this.options.stepDefinitionPackages());
        return new WorldBuilder(testClass.getClassLoader()).withFeaturePackages(featurePackages).withStepDefinitionPackages(stepDefinitionPackages).withGlobalScope(globalScope).withScenarioScope(scenarioScope).buildWorld();
    }

    private List<RunListener> buildListeners() {
        if (this.options.listeners() == null || this.options.listeners().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<RunListener> listeners = new ArrayList<RunListener>(this.options.listeners().length);
        for (Class<? extends RunListener> listenerClass : this.options.listeners()) {
            RunListener listener = (RunListener)this.getGlobalScope().getObject(listenerClass);
            listeners.add(listener);
        }
        return listeners;
    }

    public Scope getGlobalScope() {
        return this.world.getGlobalScope();
    }

    public Scope getScenarioScope() {
        return this.world.getScenarioScope();
    }

    protected String getName() {
        return "Zuchini " + Arrays.toString(this.options.featurePackages());
    }

    public Description getDescription() {
        return this.description;
    }

    public void run(RunNotifier notifier) {
        Description description = this.getDescription();
        List<RunListener> listeners = this.buildListeners();
        for (RunListener listener : listeners) {
            try {
                listener.testRunStarted(description);
                notifier.addListener(listener);
            }
            catch (Exception e) {
                notifier.fireTestFailure(new Failure(Description.TEST_MECHANISM, (Throwable)e));
            }
        }
        super.run(notifier);
    }

    public List<FeatureRunner> getChildren() {
        return this.children;
    }

    public Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    public void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }
}

