/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.junit.description;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class AnnotationHandler
implements InvocationHandler {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Set<Class<?>> ATOMIC_TYPES = new HashSet<Class>(Arrays.asList(Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class));
    private final Class<? extends Annotation> annotationType;
    private final Object bean;

    private AnnotationHandler(Class<? extends Annotation> annotationType, Object bean) {
        this.annotationType = annotationType;
        this.bean = bean;
    }

    public static <T extends Annotation> T create(Class<T> annotationType, Object bean) {
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)new AnnotationHandler(annotationType, bean)));
    }

    private static Class<? extends Annotation> castToAnnotationType(Class<?> type) {
        return type;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null) {
            args = EMPTY_ARGS;
        }
        String methodName = method.getName();
        if (args.length == 0 && methodName.equals("hashCode")) {
            return this.annotationHashCode(proxy);
        }
        if (args.length == 0 && methodName.equals("toString")) {
            return this.annotationToString(proxy);
        }
        if (args.length == 1 && methodName.equals("equals") && method.getParameterTypes()[0] == Object.class) {
            Object arg = args[0];
            if (arg == null) {
                return false;
            }
            if (proxy == arg) {
                return true;
            }
            return this.annotationEquals(proxy, arg);
        }
        if (args.length == 0 && methodName.equals("annotationType")) {
            return this.annotationType;
        }
        if (args.length == 0) {
            String getter = "get" + methodName.substring(0, 1).toUpperCase(Locale.ROOT) + methodName.substring(1);
            Method beanMethod = this.bean.getClass().getMethod(getter, new Class[0]);
            Class<?> beanReturnType = beanMethod.getReturnType();
            Class<?> annotationReturnType = method.getReturnType();
            if (annotationReturnType.isArray()) {
                Class<?> componentType = annotationReturnType.getComponentType();
                if (beanReturnType.isArray()) {
                    Object array = beanMethod.invoke(this.bean, new Object[0]);
                    int length = Array.getLength(array);
                    Object result = Array.newInstance(componentType, length);
                    if (ATOMIC_TYPES.contains(componentType)) {
                        for (int i = 0; i < length; ++i) {
                            Array.set(result, i, Array.get(array, i));
                        }
                        return result;
                    }
                    if (componentType.isAnnotation()) {
                        for (int i = 0; i < length; ++i) {
                            Array.set(result, i, AnnotationHandler.create(AnnotationHandler.castToAnnotationType(componentType), Array.get(array, i)));
                        }
                        return result;
                    }
                    throw new IllegalStateException("Unsupported component type [" + componentType.getName() + "]");
                }
                if (Collection.class.isAssignableFrom(beanReturnType)) {
                    Collection collection = (Collection)beanMethod.invoke(this.bean, new Object[0]);
                    Object result = Array.newInstance(componentType, collection.size());
                    if (ATOMIC_TYPES.contains(componentType)) {
                        int i = 0;
                        for (Object obj : collection) {
                            Array.set(result, i++, obj);
                        }
                        return result;
                    }
                    if (componentType.isAnnotation()) {
                        int i = 0;
                        for (Object obj : collection) {
                            Array.set(result, i++, AnnotationHandler.create(AnnotationHandler.castToAnnotationType(componentType), obj));
                        }
                        return result;
                    }
                    throw new IllegalStateException("Unsupported component type [" + componentType.getName() + "]");
                }
                throw new IllegalStateException("Unsupported mapping from [" + beanReturnType.getName() + "] to [" + annotationReturnType.getName() + "]");
            }
            if (ATOMIC_TYPES.contains(annotationReturnType)) {
                return beanMethod.invoke(this.bean, new Object[0]);
            }
            if (annotationReturnType.isAnnotation()) {
                Object obj = beanMethod.invoke(this.bean, new Object[0]);
                return AnnotationHandler.create(AnnotationHandler.castToAnnotationType(annotationReturnType), obj);
            }
            throw new IllegalStateException("Unsupported return type [" + annotationReturnType.getName() + "]");
        }
        throw new IllegalStateException("Unsupported method [" + methodName + "] called on annotation [" + this.bean.getClass().getName() + "]");
    }

    public boolean annotationEquals(Object proxy, Object other) {
        if (!(other instanceof Annotation)) {
            return false;
        }
        Annotation that = (Annotation)other;
        if (!this.annotationType.equals(that.annotationType())) {
            return false;
        }
        for (Method method : this.annotationType.getDeclaredMethods()) {
            Object thatValue;
            Object thisValue;
            try {
                thisValue = this.invoke(proxy, method, EMPTY_ARGS);
                thatValue = method.invoke(other, new Object[0]);
            }
            catch (RuntimeException ex1) {
                throw ex1;
            }
            catch (Throwable throwable1) {
                throw new RuntimeException(throwable1);
            }
            if (!(thisValue instanceof byte[] && thatValue instanceof byte[] ? !Arrays.equals((byte[])thisValue, (byte[])thatValue) : (thisValue instanceof short[] && thatValue instanceof short[] ? !Arrays.equals((short[])thisValue, (short[])thatValue) : (thisValue instanceof int[] && thatValue instanceof int[] ? !Arrays.equals((int[])thisValue, (int[])thatValue) : (thisValue instanceof long[] && thatValue instanceof long[] ? !Arrays.equals((long[])thisValue, (long[])thatValue) : (thisValue instanceof float[] && thatValue instanceof float[] ? !Arrays.equals((float[])thisValue, (float[])thatValue) : (thisValue instanceof double[] && thatValue instanceof double[] ? !Arrays.equals((double[])thisValue, (double[])thatValue) : (thisValue instanceof char[] && thatValue instanceof char[] ? !Arrays.equals((char[])thisValue, (char[])thatValue) : (thisValue instanceof boolean[] && thatValue instanceof boolean[] ? !Arrays.equals((boolean[])thisValue, (boolean[])thatValue) : (thisValue instanceof Object[] && thatValue instanceof Object[] ? !Arrays.equals((Object[])thisValue, (Object[])thatValue) : !thisValue.equals(thatValue))))))))))) continue;
            return false;
        }
        return true;
    }

    public int annotationHashCode(Object proxy) {
        int hashCode = 0;
        for (Method method : this.annotationType.getDeclaredMethods()) {
            Object value;
            try {
                value = this.invoke(proxy, method, EMPTY_ARGS);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            int memberValueHashCode = value instanceof boolean[] ? Arrays.hashCode((boolean[])value) : (value instanceof short[] ? Arrays.hashCode((short[])value) : (value instanceof int[] ? Arrays.hashCode((int[])value) : (value instanceof long[] ? Arrays.hashCode((long[])value) : (value instanceof float[] ? Arrays.hashCode((float[])value) : (value instanceof double[] ? Arrays.hashCode((double[])value) : (value instanceof byte[] ? Arrays.hashCode((byte[])value) : (value instanceof char[] ? Arrays.hashCode((char[])value) : (value instanceof Object[] ? Arrays.hashCode((Object[])value) : value.hashCode()))))))));
            hashCode = 31 * hashCode + memberValueHashCode;
        }
        return hashCode;
    }

    public String annotationToString(Object proxy) {
        StringBuilder string = new StringBuilder();
        string.append('@').append(this.annotationType.getName()).append('[');
        Method[] methods = this.annotationType.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Object value;
            string.append(methods[i].getName()).append('=');
            try {
                value = this.invoke(proxy, methods[i], EMPTY_ARGS);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            if (value instanceof boolean[]) {
                string.append(Arrays.toString((boolean[])value));
            } else if (value instanceof byte[]) {
                string.append(Arrays.toString((byte[])value));
            } else if (value instanceof short[]) {
                string.append(Arrays.toString((short[])value));
            } else if (value instanceof int[]) {
                string.append(Arrays.toString((int[])value));
            } else if (value instanceof long[]) {
                string.append(Arrays.toString((long[])value));
            } else if (value instanceof float[]) {
                string.append(Arrays.toString((float[])value));
            } else if (value instanceof double[]) {
                string.append(Arrays.toString((double[])value));
            } else if (value instanceof char[]) {
                string.append(Arrays.toString((char[])value));
            } else if (value instanceof Object[]) {
                string.append(Arrays.toString((Object[])value));
            } else {
                string.append(value);
            }
            if (i >= methods.length - 1) continue;
            string.append(", ");
        }
        return string.append(']').toString();
    }
}

