/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.reporter;

import javax.annotation.Nullable;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

class ScenarioResult {
    private final Description description;
    @Nullable
    private final Throwable exception;
    private final boolean assumptionFailed;
    private final boolean ignored;

    public static ScenarioResult failure(Failure failure) {
        return new ScenarioResult(failure.getDescription(), failure.getException(), false, false);
    }

    public static ScenarioResult assumptionFailed(Failure failure) {
        return new ScenarioResult(failure.getDescription(), failure.getException(), true, false);
    }

    public static ScenarioResult ignored(Description description) {
        return new ScenarioResult(description, null, false, true);
    }

    public static ScenarioResult success(Description description) {
        return new ScenarioResult(description, null, false, false);
    }

    private ScenarioResult(Description description, @Nullable Throwable exception, boolean assumptionFailed, boolean ignored) {
        this.description = description;
        this.exception = exception;
        this.assumptionFailed = assumptionFailed;
        this.ignored = ignored;
    }

    public boolean isSuccess() {
        return this.exception == null && !this.assumptionFailed && !this.ignored;
    }

    public Description getDescription() {
        return this.description;
    }

    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    public boolean isAssumptionFailed() {
        return this.assumptionFailed;
    }

    public boolean isIgnored() {
        return this.ignored;
    }
}

