/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.zuchini.runner.Convert;
import org.zuchini.runner.Converter;
import org.zuchini.runner.Scope;

public class Converters {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final Map<Class<?>, Converter<?>> DEFAULT_CONVERTERS;

    private Converters() {
    }

    public static <T> Converter<T> getConverter(Scope scope, Class<T> parameterType) {
        return Converters.getConverter(scope, parameterType, EMPTY_ANNOTATIONS);
    }

    public static <T> Converter<T> getConverter(Scope scope, Class<T> parameterType, Annotation[] parameterAnnotations) {
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (parameterAnnotation.annotationType() != Convert.class) continue;
            Class<Converter<?>> argumentConverterClass = ((Convert)parameterAnnotation).value();
            Converter<?> converter = scope.getObject(argumentConverterClass);
            return Converters.cast(parameterType, converter);
        }
        Converter<?> converter = DEFAULT_CONVERTERS.get(parameterType);
        if (converter != null) {
            return Converters.cast(parameterType, converter);
        }
        if (parameterType.isEnum()) {
            return Converters.newEnumConverter(parameterType);
        }
        throw new IllegalStateException("Could not find argument converter for type [" + parameterType.getName() + "]");
    }

    static <T> Converter<T> newEnumConverter(Class<?> parameterType) {
        Class<?> enumType = parameterType;
        return new EnumConverter(enumType);
    }

    private static <T> Converter<T> cast(Class<T> parameterType, Converter<?> converter) {
        return converter;
    }

    static {
        HashMap<Class<BigDecimal>, DefaultConverters> map = new HashMap<Class<BigDecimal>, DefaultConverters>(32);
        map.put(Byte.TYPE, DefaultConverters.BYTE);
        map.put(Byte.class, DefaultConverters.BYTE);
        map.put(Short.TYPE, DefaultConverters.SHORT);
        map.put(Short.class, DefaultConverters.SHORT);
        map.put(Integer.TYPE, DefaultConverters.INT);
        map.put(Integer.class, DefaultConverters.INT);
        map.put(Long.TYPE, DefaultConverters.LONG);
        map.put(Long.class, DefaultConverters.LONG);
        map.put(Float.TYPE, DefaultConverters.FLOAT);
        map.put(Float.class, DefaultConverters.FLOAT);
        map.put(Double.TYPE, DefaultConverters.DOUBLE);
        map.put(Double.class, DefaultConverters.DOUBLE);
        map.put(Character.TYPE, DefaultConverters.CHARACTER);
        map.put(Character.class, DefaultConverters.CHARACTER);
        map.put(Boolean.TYPE, DefaultConverters.BOOLEAN);
        map.put(Boolean.class, DefaultConverters.BOOLEAN);
        map.put(String.class, DefaultConverters.STRING);
        map.put(Object.class, DefaultConverters.STRING);
        map.put(BigInteger.class, DefaultConverters.BIGINT);
        map.put(BigDecimal.class, DefaultConverters.BIGDECIMAL);
        DEFAULT_CONVERTERS = Collections.unmodifiableMap(map);
    }

    static class EnumConverter<E extends Enum<E>>
    implements Converter<E> {
        private final Class<E> enumClass;

        EnumConverter(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public E convert(@Nullable String argument) {
            if (argument == null || argument.length() == 0) {
                return null;
            }
            return Enum.valueOf(this.enumClass, argument);
        }
    }

    static enum DefaultConverters implements Converter
    {
        BYTE{

            public Object convert(String argument) {
                return Byte.valueOf(argument);
            }
        }
        ,
        SHORT{

            public Object convert(String argument) {
                return Short.valueOf(argument);
            }
        }
        ,
        INT{

            public Object convert(String argument) {
                return Integer.valueOf(argument);
            }
        }
        ,
        LONG{

            public Object convert(String argument) {
                return Long.valueOf(argument);
            }
        }
        ,
        FLOAT{

            public Object convert(String argument) {
                return Float.valueOf(argument);
            }
        }
        ,
        DOUBLE{

            public Object convert(String argument) {
                return Double.valueOf(argument);
            }
        }
        ,
        CHARACTER{

            public Object convert(String argument) {
                if (argument.length() != 1) {
                    throw new IllegalArgumentException("Could not convert string of length " + argument.length() + " to char");
                }
                return Character.valueOf(argument.charAt(0));
            }
        }
        ,
        BOOLEAN{
            private final Map<String, Boolean> MAP = new TreeMap<String, Boolean>(String.CASE_INSENSITIVE_ORDER);
            {
                for (String value : Arrays.asList("true", "1", "yes", "y")) {
                    this.MAP.put(value, Boolean.TRUE);
                }
                for (String value : Arrays.asList("false", "0", "no", "n")) {
                    this.MAP.put(value, Boolean.FALSE);
                }
            }

            public Object convert(String argument) {
                Boolean b = this.MAP.get(argument);
                if (b == null) {
                    throw new IllegalArgumentException("Could not convert argument to boolean");
                }
                return b;
            }
        }
        ,
        STRING{

            public Object convert(String argument) {
                return argument;
            }
        }
        ,
        BIGINT{

            public Object convert(String argument) {
                return new BigInteger(argument);
            }
        }
        ,
        BIGDECIMAL{

            public Object convert(String argument) {
                return new BigDecimal(argument);
            }
        };

    }
}

