/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner;

import java.util.Collections;
import java.util.List;
import org.zuchini.model.Feature;
import org.zuchini.runner.Context;
import org.zuchini.runner.ScenarioStatement;
import org.zuchini.runner.Statement;

public class FeatureStatement
implements Statement {
    private final Feature feature;
    private final List<? extends ScenarioStatement> scenarios;

    public FeatureStatement(Feature feature, List<? extends ScenarioStatement> scenarios) {
        this.feature = feature;
        this.scenarios = scenarios;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public List<? extends ScenarioStatement> getScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    @Override
    public void evaluate(Context context) throws Throwable {
        for (ScenarioStatement scenarioStatement : this.scenarios) {
            scenarioStatement.evaluate(context);
        }
    }
}

