/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner;

import java.util.List;
import javax.annotation.Nullable;
import org.zuchini.model.Scenario;
import org.zuchini.runner.BackgroundStatement;
import org.zuchini.runner.Context;
import org.zuchini.runner.HookStatement;
import org.zuchini.runner.ScenarioStatement;
import org.zuchini.runner.Scope;
import org.zuchini.runner.StepStatement;

public class SimpleScenarioStatement
extends ScenarioStatement {
    private final Scenario scenario;
    @Nullable
    private final BackgroundStatement background;
    private final List<StepStatement> steps;
    private final List<HookStatement> beforeHooks;
    private final List<HookStatement> afterHooks;

    public SimpleScenarioStatement(Scenario scenario, BackgroundStatement background, List<StepStatement> steps, List<HookStatement> beforeHooks, List<HookStatement> afterHooks) {
        this.scenario = scenario;
        this.background = background;
        this.steps = steps;
        this.beforeHooks = beforeHooks;
        this.afterHooks = afterHooks;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public List<StepStatement> getSteps() {
        return this.steps;
    }

    public List<HookStatement> getBeforeHooks() {
        return this.beforeHooks;
    }

    public List<HookStatement> getAfterHooks() {
        return this.afterHooks;
    }

    @Override
    public boolean isOutline() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(Context context) throws Throwable {
        Scope scope = context.getScenarioScope();
        scope.begin();
        try {
            for (HookStatement beforeHook : this.beforeHooks) {
                beforeHook.evaluate(context);
            }
            if (this.background != null) {
                this.background.evaluate(context);
            }
            for (StepStatement step : this.steps) {
                step.evaluate(context);
            }
            for (HookStatement afterHook : this.afterHooks) {
                afterHook.evaluate(context);
            }
        }
        finally {
            scope.end();
        }
    }
}

