/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zuchini.model.Background;
import org.zuchini.model.Feature;
import org.zuchini.model.Outline;
import org.zuchini.model.Scenario;
import org.zuchini.model.Step;
import org.zuchini.model.StepContainer;
import org.zuchini.runner.BackgroundStatement;
import org.zuchini.runner.FeatureStatement;
import org.zuchini.runner.HookDefinition;
import org.zuchini.runner.HookStatement;
import org.zuchini.runner.OutlineStatement;
import org.zuchini.runner.ScenarioStatement;
import org.zuchini.runner.SimpleScenarioStatement;
import org.zuchini.runner.StepDefinition;
import org.zuchini.runner.StepStatement;

class StatementBuilder {
    private final List<StepDefinition> stepDefinitions;
    private final List<HookDefinition> hookDefinitions;
    private final Map<String, Closure> methodCache;

    StatementBuilder(List<StepDefinition> stepDefinitions, List<HookDefinition> hookDefinitions) {
        this.stepDefinitions = stepDefinitions;
        this.hookDefinitions = hookDefinitions;
        this.methodCache = new HashMap<String, Closure>();
    }

    public List<FeatureStatement> buildFeatureStatements(List<Feature> features) {
        ArrayList<FeatureStatement> statements = new ArrayList<FeatureStatement>(features.size());
        for (Feature feature : features) {
            statements.add(this.buildFeatureStatement(feature));
        }
        return statements;
    }

    public FeatureStatement buildFeatureStatement(Feature feature) {
        List scenarios = feature.getScenarios();
        ArrayList<ScenarioStatement> statements = new ArrayList<ScenarioStatement>(scenarios.size());
        for (StepContainer stepContainer : scenarios) {
            if (stepContainer instanceof Outline) {
                Outline outline = (Outline)stepContainer;
                statements.add(this.buildOutlineStatement(outline));
                continue;
            }
            statements.add(this.buildScenarioStatement((Scenario)stepContainer));
        }
        return new FeatureStatement(feature, statements);
    }

    private OutlineStatement buildOutlineStatement(Outline outline) {
        List scenarios = outline.buildScenarios();
        ArrayList<SimpleScenarioStatement> statements = new ArrayList<SimpleScenarioStatement>(scenarios.size());
        for (Scenario scenario : scenarios) {
            statements.add(this.buildScenarioStatement(scenario));
        }
        return new OutlineStatement(outline, statements);
    }

    private SimpleScenarioStatement buildScenarioStatement(Scenario scenario) {
        BackgroundStatement backgroundStatement;
        ArrayList<StepStatement> scenarioSteps = new ArrayList<StepStatement>();
        ArrayList<StepStatement> backgroundSteps = new ArrayList<StepStatement>();
        if (scenario.getBackground().isEmpty()) {
            backgroundStatement = null;
        } else {
            Background background = (Background)scenario.getBackground().get(0);
            List steps = background.getSteps();
            Iterator<Object> iterator = steps.iterator();
            while (iterator.hasNext()) {
                Step step = (Step)iterator.next();
                backgroundSteps.add(this.buildStepStatement(step));
            }
            backgroundStatement = new BackgroundStatement(background, backgroundSteps);
        }
        List steps = scenario.getSteps();
        for (Step step : steps) {
            scenarioSteps.add(this.buildStepStatement(step));
        }
        ArrayList<HookStatement> beforeHooks = new ArrayList<HookStatement>();
        ArrayList<HookStatement> afterHooks = new ArrayList<HookStatement>();
        block2: for (HookDefinition hookDefinition : this.hookDefinitions) {
            ArrayList<HookStatement> list = hookDefinition.getEvent() == HookDefinition.Event.BEFORE ? beforeHooks : afterHooks;
            Set<String> tags = hookDefinition.getTags();
            for (String tag : tags) {
                if (scenario.getTags().contains(tag)) continue;
                continue block2;
            }
            list.add(new HookStatement(scenario, hookDefinition.getMethod()));
        }
        return new SimpleScenarioStatement(scenario, backgroundStatement, scenarioSteps, beforeHooks, afterHooks);
    }

    private StepStatement buildStepStatement(Step step) {
        Closure closure = this.methodCache.get(step.getName());
        if (closure == null) {
            closure = this.findMethod(step.getName());
            this.methodCache.put(step.getName(), closure);
        }
        return new StepStatement(step, closure.getMethod(), closure.getArguments());
    }

    private String[] groups(Matcher matcher) {
        int groupCount = matcher.groupCount();
        String[] groups = new String[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            groups[i] = matcher.group(i + 1);
        }
        return groups;
    }

    private Closure findMethod(String description) {
        ArrayList<Closure> methods = new ArrayList<Closure>(2);
        for (StepDefinition stepDefinition : this.stepDefinitions) {
            Pattern pattern = stepDefinition.getPattern();
            Matcher matcher = pattern.matcher(description);
            if (!matcher.matches()) continue;
            Method method = stepDefinition.getMethod();
            Closure closure = new Closure(method, this.groups(matcher));
            methods.add(closure);
        }
        if (methods.isEmpty()) {
            throw new IllegalStateException("Could not find step definition for [" + description + "]");
        }
        if (methods.size() > 1) {
            throw new IllegalStateException("Multiple matching methods for [" + description + "]");
        }
        return (Closure)methods.get(0);
    }

    static class Closure {
        private final Method method;
        private final String[] arguments;

        Closure(Method method, String[] arguments) {
            this.method = method;
            this.arguments = arguments;
        }

        Method getMethod() {
            return this.method;
        }

        String[] getArguments() {
            return this.arguments;
        }
    }
}

