/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.zuchini.annotations.After;
import org.zuchini.annotations.Before;
import org.zuchini.annotations.StepAnnotation;
import org.zuchini.runner.HookDefinition;
import org.zuchini.runner.StepDefinition;
import org.zuchini.runner.internal.ClasspathScanner;

class StepDefinitionScanner
extends ClasspathScanner {
    private static final Class<? extends Annotation> COMPAT_STEP_DEF_ANNOTATION = StepDefinitionScanner.getClassForName("cucumber.runtime.java.StepDefAnnotation");
    private static final Class<? extends Annotation> COMPAT_BEFORE = StepDefinitionScanner.getClassForName("cucumber.api.java.Before");
    private static final Class<? extends Annotation> COMPAT_AFTER = StepDefinitionScanner.getClassForName("cucumber.api.java.After");
    private final List<StepDefinition> stepDefinitions = new ArrayList<StepDefinition>();
    private final List<HookDefinition> hookDefinitions = new ArrayList<HookDefinition>();

    StepDefinitionScanner(ClassLoader classLoader, List<String> packageNames) {
        super(classLoader, packageNames, ".class");
    }

    private static Class<? extends Annotation> getClassForName(String className) {
        try {
            ClassLoader cl = StepDefinitionScanner.class.getClassLoader();
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static <T> T getAnnotationValue(Annotation annotation, Class<T> returnType) {
        try {
            Method valueMethod = annotation.annotationType().getMethod("value", new Class[0]);
            return returnType.cast(valueMethod.invoke((Object)annotation, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unexpected exception while getting annotation value");
        }
    }

    private static String getAnnotationValueString(Annotation annotation) {
        return StepDefinitionScanner.getAnnotationValue(annotation, String.class);
    }

    private static String[] getAnnotationValueStringArray(Annotation annotation) {
        return StepDefinitionScanner.getAnnotationValue(annotation, String[].class);
    }

    private static boolean isStepAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.getAnnotation(StepAnnotation.class) != null;
    }

    private static boolean isCompatStepAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return COMPAT_STEP_DEF_ANNOTATION != null && annotationType.getAnnotation(COMPAT_STEP_DEF_ANNOTATION) != null;
    }

    private static boolean isBeforeHook(Annotation annotation) {
        return annotation.annotationType() == Before.class || annotation.annotationType() == COMPAT_BEFORE;
    }

    private static boolean isAfterHook(Annotation annotation) {
        return annotation.annotationType() == After.class || annotation.annotationType() == COMPAT_AFTER;
    }

    private static boolean isPublic(Method method) {
        return (method.getModifiers() & 1) != 0;
    }

    private static Set<String> includedTags(String[] tags) {
        HashSet<String> result = new HashSet<String>(tags.length);
        for (String tag : tags) {
            if (tag.startsWith("~")) continue;
            result.add(tag.startsWith("@") ? tag.substring(1) : tag);
        }
        return result;
    }

    private static Set<String> excludedTags(String[] tags) {
        HashSet<String> result = new HashSet<String>(tags.length);
        for (String tag : tags) {
            if (!tag.startsWith("~")) continue;
            result.add(tag.startsWith("~@") ? tag.substring(2) : tag.substring(1));
        }
        return result;
    }

    @Override
    protected void handleResource(String classResource) {
        String className = classResource.replace('/', '.').replaceFirst(".class$", "");
        try {
            Class<?> clazz = Class.forName(className, false, this.classLoader);
            for (Method method : clazz.getDeclaredMethods()) {
                if (!StepDefinitionScanner.isPublic(method)) continue;
                for (Annotation annotation : method.getAnnotations()) {
                    HashSet<String> tags;
                    String[] value;
                    if (StepDefinitionScanner.isStepAnnotation(annotation) || StepDefinitionScanner.isCompatStepAnnotation(annotation)) {
                        value = StepDefinitionScanner.getAnnotationValueString(annotation);
                        this.stepDefinitions.add(new StepDefinition((String)value, method));
                        continue;
                    }
                    if (StepDefinitionScanner.isBeforeHook(annotation)) {
                        value = StepDefinitionScanner.getAnnotationValueStringArray(annotation);
                        tags = new HashSet<String>(Arrays.asList(value));
                        this.hookDefinitions.add(new HookDefinition(HookDefinition.Event.BEFORE, tags, method));
                        continue;
                    }
                    if (!StepDefinitionScanner.isAfterHook(annotation)) continue;
                    value = StepDefinitionScanner.getAnnotationValueStringArray(annotation);
                    tags = new HashSet<String>(Arrays.asList(value));
                    this.hookDefinitions.add(new HookDefinition(HookDefinition.Event.AFTER, tags, method));
                }
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            System.err.println(classResource);
            e.printStackTrace();
        }
    }

    List<StepDefinition> getStepDefinitions() {
        return this.stepDefinitions;
    }

    List<HookDefinition> getHookDefinitions() {
        return this.hookDefinitions;
    }
}

