/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner;

import java.util.List;
import org.zuchini.runner.Context;
import org.zuchini.runner.FeatureStatement;
import org.zuchini.runner.Scope;

public class World
implements Context {
    private final Scope globalScope;
    private final Scope scenarioScope;
    private final List<FeatureStatement> featureStatements;

    World(Scope globalScope, Scope scenarioScope, List<FeatureStatement> featureStatements) {
        this.globalScope = globalScope;
        this.scenarioScope = scenarioScope;
        this.featureStatements = featureStatements;
    }

    @Override
    public Scope getGlobalScope() {
        return this.globalScope;
    }

    @Override
    public Scope getScenarioScope() {
        return this.scenarioScope;
    }

    public List<FeatureStatement> getFeatureStatements() {
        return this.featureStatements;
    }

    public void run() throws Throwable {
        this.globalScope.begin();
        try {
            for (FeatureStatement statement : this.getFeatureStatements()) {
                statement.evaluate(this);
            }
        }
        finally {
            this.globalScope.end();
        }
    }
}

