/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner.tables;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.zuchini.runner.tables.NamingConvention;

public class BeanInfoNamingConvention
implements NamingConvention {
    private final Class<?> beanClass;
    private final PropertyDescriptor[] properties;

    public BeanInfoNamingConvention(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.properties = BeanInfoNamingConvention.getProperties(beanClass);
    }

    private static PropertyDescriptor[] getProperties(Class<?> beanClass) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Could not inspect [" + beanClass.getName() + "]", e);
        }
    }

    @Override
    public String toDisplayName(String property) {
        for (PropertyDescriptor propertyDescriptor : this.properties) {
            if (!property.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor.getDisplayName();
        }
        throw new IllegalStateException("Could not find property descriptor for property [" + property + "] in [" + this.beanClass.getName() + "]");
    }

    @Override
    public String toProperty(String displayName) {
        for (PropertyDescriptor propertyDescriptor : this.properties) {
            if (!displayName.equals(propertyDescriptor.getDisplayName())) continue;
            return propertyDescriptor.getName();
        }
        throw new IllegalStateException("Could not find property descriptor for display name [" + displayName + "] in [" + this.beanClass.getName() + "]");
    }

    public String toString() {
        return "BeanInfoNamingConvention<" + this.beanClass.getName() + ">";
    }
}

