/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner.tables;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.zuchini.runner.tables.DisplayName;

public abstract class EnhancedBeanInfo
implements BeanInfo {
    private final BeanInfo delegate;
    private final PropertyDescriptor[] propertyDescriptors;

    protected EnhancedBeanInfo(Class<?> beanClass) {
        try {
            this.delegate = Introspector.getBeanInfo(beanClass, 2);
            this.propertyDescriptors = EnhancedBeanInfo.getPropertyDescriptorsWithDisplayName(this.delegate);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Could not introspect [" + beanClass.getName() + "]");
        }
    }

    private static PropertyDescriptor[] getPropertyDescriptorsWithDisplayName(BeanInfo beanInfo) {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            EnhancedBeanInfo.updateDisplayName(propertyDescriptor);
        }
        return propertyDescriptors;
    }

    private static void updateDisplayName(PropertyDescriptor propertyDescriptor) {
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        DisplayName displayName = null;
        if (readMethod != null) {
            displayName = readMethod.getAnnotation(DisplayName.class);
        }
        if (displayName == null && writeMethod != null) {
            displayName = writeMethod.getAnnotation(DisplayName.class);
        }
        if (displayName != null && displayName.value() != null) {
            propertyDescriptor.setDisplayName(displayName.value());
        }
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.delegate.getBeanDescriptor();
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.delegate.getDefaultPropertyIndex();
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.delegate.getEventSetDescriptors();
    }

    @Override
    public int getDefaultEventIndex() {
        return this.delegate.getDefaultEventIndex();
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.delegate.getMethodDescriptors();
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return this.delegate.getAdditionalBeanInfo();
    }

    @Override
    public Image getIcon(int iconKind) {
        return this.delegate.getIcon(iconKind);
    }
}

