/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.zuchini.model.Step;
import org.zuchini.runner.Context;
import org.zuchini.runner.Converter;
import org.zuchini.runner.Converters;
import org.zuchini.runner.Scope;
import org.zuchini.runner.Statement;
import org.zuchini.runner.tables.Datatable;

public class StepStatement
implements Statement {
    private final Step step;
    private final Method method;
    private final String[] stringArguments;

    public StepStatement(Step step, Method method, String[] stringArguments) {
        this.step = step;
        this.method = method;
        this.stringArguments = stringArguments;
    }

    public Step getStep() {
        return this.step;
    }

    private Object[] convertArguments(Context context, Class<?>[] parameterTypes, Annotation[][] parameterAnnotations) {
        assert (parameterTypes.length == parameterAnnotations.length);
        assert (this.stringArguments.length <= parameterTypes.length);
        Scope globalScope = context.getGlobalScope();
        Object[] typedArguments = new Object[parameterTypes.length];
        for (int i = 0; i < this.stringArguments.length; ++i) {
            Converter<?> converter = Converters.getConverter(globalScope, parameterTypes[i], parameterAnnotations[i]);
            Object argument = converter.convert(this.stringArguments[i]);
            typedArguments[i] = argument;
        }
        return typedArguments;
    }

    private Object[] convertArguments(Context context) {
        Object[] parameterTypes = this.method.getParameterTypes();
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        int parameterCount = parameterTypes.length;
        if (this.stringArguments.length == parameterCount) {
            Object[] typedArguments = this.convertArguments(context, (Class<?>[])parameterTypes, parameterAnnotations);
            return typedArguments;
        }
        List rows = this.step.getRows();
        List docs = this.step.getDocs();
        if (!rows.isEmpty() && this.stringArguments.length + 1 == parameterCount && parameterTypes[this.stringArguments.length] == Datatable.class) {
            Object[] typedArguments = this.convertArguments(context, (Class<?>[])parameterTypes, parameterAnnotations);
            typedArguments[this.stringArguments.length] = Datatable.fromRows(rows);
            return typedArguments;
        }
        if (docs.size() == 1 && this.stringArguments.length + 1 == parameterCount && parameterTypes[this.stringArguments.length] == String.class) {
            Object[] typedArguments = this.convertArguments(context, (Class<?>[])parameterTypes, parameterAnnotations);
            typedArguments[this.stringArguments.length] = docs.get(0);
            return typedArguments;
        }
        String description = this.step.getName();
        String methodName = this.method.getDeclaringClass().getName() + "." + this.method.getName();
        throw new IllegalStateException("Could not convert parameters " + Arrays.toString(this.stringArguments) + " for step [" + description + "] to method [" + methodName + "] with arguments " + Arrays.toString(parameterTypes));
    }

    @Override
    public void evaluate(Context context) throws Throwable {
        try {
            Scope scenarioScope = context.getScenarioScope();
            Object target = scenarioScope.getObject(this.method.getDeclaringClass());
            Object[] typedArguments = this.convertArguments(context);
            this.method.invoke(target, typedArguments);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }
}

