/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zuchini.model.Feature;
import org.zuchini.parser.FeatureParser;
import org.zuchini.runner.FeatureScanner;
import org.zuchini.runner.FeatureStatement;
import org.zuchini.runner.GlobalScope;
import org.zuchini.runner.HookDefinition;
import org.zuchini.runner.Scope;
import org.zuchini.runner.StatementBuilder;
import org.zuchini.runner.StepDefinition;
import org.zuchini.runner.StepDefinitionScanner;
import org.zuchini.runner.ThreadLocalScope;
import org.zuchini.runner.World;

public class WorldBuilder {
    private final ClassLoader classLoader;
    private final List<String> featurePackages = new ArrayList<String>();
    private final List<File> featureFiles = new ArrayList<File>();
    private final List<String> stepDefinitionPackages = new ArrayList<String>();
    private Scope globalScope;
    private Scope scenarioScope;

    public WorldBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public WorldBuilder withGlobalScope(Scope globalScope) {
        this.globalScope = globalScope;
        return this;
    }

    public WorldBuilder withScenarioScope(Scope scenarioScope) {
        this.scenarioScope = scenarioScope;
        return this;
    }

    public WorldBuilder withFeaturePackages(List<String> featurePackages) {
        this.featurePackages.addAll(featurePackages);
        return this;
    }

    public WorldBuilder addFeaturePackage(String featurePackage) {
        this.featurePackages.add(featurePackage);
        return this;
    }

    public WorldBuilder withFeatureFiles(List<File> featureFiles) {
        this.featureFiles.addAll(featureFiles);
        return this;
    }

    public WorldBuilder addFeatureFile(File featureFile) {
        this.featureFiles.add(featureFile);
        return this;
    }

    public WorldBuilder withStepDefinitionPackages(List<String> stepDefinitionPackages) {
        this.stepDefinitionPackages.addAll(stepDefinitionPackages);
        return this;
    }

    public WorldBuilder addStepDefinitionPackage(String stepDefinitionPackage) {
        this.stepDefinitionPackages.add(stepDefinitionPackage);
        return this;
    }

    public World buildWorld() throws IOException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (!this.featurePackages.isEmpty()) {
            features.addAll(FeatureScanner.scan(this.classLoader, this.featurePackages));
        }
        if (!this.featureFiles.isEmpty()) {
            for (File file : this.featureFiles) {
                features.add(FeatureParser.getFeature((File)file));
            }
        }
        if (this.globalScope == null) {
            this.globalScope = new GlobalScope();
        }
        if (this.scenarioScope == null) {
            this.scenarioScope = new ThreadLocalScope();
        }
        StepDefinitionScanner scanner = new StepDefinitionScanner(this.classLoader, this.stepDefinitionPackages);
        scanner.scan();
        List<StepDefinition> stepDefinitions = scanner.getStepDefinitions();
        List<HookDefinition> hookDefinitions = scanner.getHookDefinitions();
        StatementBuilder statementBuilder = new StatementBuilder(stepDefinitions, hookDefinitions);
        List<FeatureStatement> featureStatements = statementBuilder.buildFeatureStatements(features);
        return new World(this.globalScope, this.scenarioScope, featureStatements);
    }
}

