/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner.tables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zuchini.model.Row;
import org.zuchini.runner.tables.NamingConvention;
import org.zuchini.runner.tables.NamingConventions;

public class Datatable {
    private final List<List<String>> rows;

    private Datatable(List<List<String>> rows) {
        this.rows = rows;
    }

    private static List<String> unmodifiableCopy(List<String> list) {
        String[] array = list.toArray(new String[list.size()]);
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    public static Datatable fromRows(List<Row> rows) {
        ArrayList<List<String>> list = new ArrayList<List<String>>(rows.size());
        for (Row row : rows) {
            List cells = row.getCells();
            list.add(Datatable.unmodifiableCopy(cells));
        }
        return new Datatable(Collections.unmodifiableList(list));
    }

    public static Datatable fromLists(List<List<String>> rows) {
        ArrayList<List<String>> list = new ArrayList<List<String>>(rows.size());
        for (List<String> row : rows) {
            list.add(Datatable.unmodifiableCopy(row));
        }
        return new Datatable(Collections.unmodifiableList(list));
    }

    public static Datatable fromMaps(List<Map<String, String>> objects, List<String> header, NamingConvention namingConvention) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>(objects.size() + 1);
        rows.add(header);
        for (Map<String, String> object : objects) {
            ArrayList<String> row = new ArrayList<String>(header.size());
            for (String title : header) {
                String value = object.get(namingConvention.toProperty(title));
                row.add(value == null ? "" : value);
            }
            rows.add(row);
        }
        return new Datatable(Collections.unmodifiableList(rows));
    }

    public static Datatable fromMaps(List<Map<String, String>> objects, List<String> header) {
        return Datatable.fromMaps(objects, header, NamingConventions.DefaultNamingConventions.IDENTITY);
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public List<String> getHeader() {
        return this.rows.get(0);
    }

    public List<List<String>> getData() {
        return this.rows.subList(1, this.rows.size());
    }

    public List<Map<String, String>> toMap(NamingConvention namingConvention) {
        List<String> headerCells = this.getHeader();
        String[] headerProperties = new String[headerCells.size()];
        int len = headerCells.size();
        for (int i = 0; i < len; ++i) {
            headerProperties[i] = namingConvention.toProperty(headerCells.get(i));
        }
        List<List<String>> rows = this.getData();
        ArrayList<Map<String, String>> objects = new ArrayList<Map<String, String>>(rows.size());
        for (List<String> row : rows) {
            assert (row.size() == headerProperties.length);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(headerProperties.length);
            int len2 = row.size();
            for (int i = 0; i < len2; ++i) {
                map.put(headerProperties[i], row.get(i));
            }
            objects.add(map);
        }
        return objects;
    }

    public List<Map<String, String>> toMap() {
        return this.toMap(NamingConventions.DefaultNamingConventions.IDENTITY);
    }
}

