/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner.tables;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.zuchini.runner.tables.Datatable;
import org.zuchini.runner.tables.Diff;

class DatatableMatcher
extends TypeSafeDiagnosingMatcher<Datatable> {
    private final Datatable expected;

    DatatableMatcher(Datatable expected) {
        super(Datatable.class);
        this.expected = expected;
    }

    private static String[][] toArray(Datatable table) {
        List<List<String>> rows = table.getRows();
        String[][] array = new String[rows.size()][];
        for (int i = 0; i < rows.size(); ++i) {
            List<String> row = rows.get(i);
            array[i] = row.toArray(new String[row.size()]);
        }
        return array;
    }

    private static void updateWidths(int[] widths, String[][] array) {
        int rows = array.length;
        int cols = array[0].length;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int len = array[row][col].length();
                if (len <= widths[col]) continue;
                widths[col] = len;
            }
        }
    }

    private static String[] formatDatatable(String[][] array, int[] widths) {
        int rows = array.length;
        int cols = array[0].length;
        String[] lines = new String[rows];
        for (int row = 0; row < rows; ++row) {
            assert (array[row].length == widths.length);
            StringBuilder sb = new StringBuilder(128);
            sb.append(" | ");
            for (int col = 0; col < cols; ++col) {
                String str = array[row][col];
                sb.append(str);
                for (int i = str.length(); i < widths[col]; ++i) {
                    sb.append(" ");
                }
                if (col >= cols - 1) continue;
                sb.append(" | ");
            }
            sb.append(" |");
            lines[row] = sb.toString();
        }
        return lines;
    }

    private static String[] formatDatatable(Datatable table) {
        String[][] array = DatatableMatcher.toArray(table);
        int[] widths = new int[array[0].length];
        DatatableMatcher.updateWidths(widths, array);
        return DatatableMatcher.formatDatatable(array, widths);
    }

    private static String[] formatDiff(String[] lines1, String[] lines2) {
        return Diff.formatDiff(lines1, lines2);
    }

    protected boolean matchesSafely(Datatable item, Description mismatchDescription) {
        String[][] expectedArray = DatatableMatcher.toArray(this.expected);
        String[][] actualArray = DatatableMatcher.toArray(item);
        int[] widths = new int[expectedArray[0].length];
        DatatableMatcher.updateWidths(widths, expectedArray);
        DatatableMatcher.updateWidths(widths, actualArray);
        Object[] expectedLines = DatatableMatcher.formatDatatable(expectedArray, widths);
        Object[] actualLines = DatatableMatcher.formatDatatable(actualArray, widths);
        if (Arrays.equals(expectedLines, actualLines)) {
            return true;
        }
        mismatchDescription.appendText("did not match\n\n");
        for (String line : DatatableMatcher.formatDiff((String[])expectedLines, (String[])actualLines)) {
            mismatchDescription.appendText(line).appendText("\n");
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("datatable matching\n\n");
        for (String line : DatatableMatcher.formatDatatable(this.expected)) {
            description.appendText(" ").appendText(line).appendText("\n");
        }
    }
}

