/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.runner.tables;

import java.util.ArrayList;

class Diff {
    private Diff() {
    }

    static <T> String[] formatDiff(T[] x, T[] y) {
        int M = x.length;
        int N = y.length;
        int[][] opt = new int[M + 1][N + 1];
        for (int i = M - 1; i >= 0; --i) {
            for (int j = N - 1; j >= 0; --j) {
                opt[i][j] = x[i].equals(y[j]) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        ArrayList<String> diff = new ArrayList<String>(M + N);
        int i = 0;
        int j = 0;
        while (i < M && j < N) {
            if (x[i].equals(y[j])) {
                diff.add(" " + x[i]);
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                diff.add("-" + x[i++]);
                continue;
            }
            diff.add("+" + y[j++]);
        }
        while (i < M || j < N) {
            if (i == M) {
                diff.add("+" + y[j++]);
                continue;
            }
            if (j != N) continue;
            diff.add("-" + x[i++]);
        }
        return diff.toArray(new String[diff.size()]);
    }
}

