/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.spring;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.zuchini.spring.BeanFactoryScope;

class ScopeExecutionListener
implements TestExecutionListener {
    private final BeanFactoryScope globalScope;
    private final BeanFactoryScope scenarioScope;

    ScopeExecutionListener(BeanFactoryScope globalScope, BeanFactoryScope scenarioScope) {
        this.globalScope = globalScope;
        this.scenarioScope = scenarioScope;
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
        this.globalScope.setBeanFactory((BeanFactory)beanFactory);
        this.scenarioScope.setBeanFactory((BeanFactory)beanFactory);
        this.globalScope.begin();
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        this.globalScope.end();
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
    }
}

