/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.spring;

import java.util.Collections;
import org.junit.runners.Suite;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.junit4.statements.RunAfterTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestClassCallbacks;
import org.zuchini.junit.ZuchiniRunnerDelegate;
import org.zuchini.runner.Scope;
import org.zuchini.spring.BeanFactoryScope;
import org.zuchini.spring.ScopeExecutionListener;

public class SpringZuchini
extends Suite {
    private final TestContextManager testContextManager;

    public SpringZuchini(Class<?> testClass) throws Exception {
        super(testClass, Collections.singletonList(new ZuchiniRunnerDelegate(testClass, (Scope)new BeanFactoryScope(false), (Scope)new BeanFactoryScope(true))));
        ZuchiniRunnerDelegate delegate = (ZuchiniRunnerDelegate)this.getChildren().get(0);
        BeanFactoryScope globalScope = (BeanFactoryScope)delegate.getGlobalScope();
        BeanFactoryScope scenarioScope = (BeanFactoryScope)delegate.getScenarioScope();
        this.testContextManager = new TestContextManager(testClass);
        this.testContextManager.registerTestExecutionListeners(new TestExecutionListener[]{new ScopeExecutionListener(globalScope, scenarioScope)});
    }

    protected Statement withBeforeClasses(Statement statement) {
        Statement junitBeforeClasses = super.withBeforeClasses(statement);
        return new RunBeforeTestClassCallbacks(junitBeforeClasses, this.testContextManager);
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement junitAfterClasses = super.withAfterClasses(statement);
        return new RunAfterTestClassCallbacks(junitAfterClasses, this.testContextManager);
    }
}

