/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.spring;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.zuchini.runner.GlobalScope;
import org.zuchini.runner.Scope;
import org.zuchini.spring.SpringThreadLocalScope;

class BeanFactoryScope
implements Scope {
    private boolean clearThreadLocalScope;
    private BeanFactory beanFactory;
    private GlobalScope fallback;

    BeanFactoryScope(boolean clearThreadLocalScope) {
        this.clearThreadLocalScope = clearThreadLocalScope;
        this.fallback = new GlobalScope();
    }

    void setBeanFactory(BeanFactory beanFactory) {
        if (this.beanFactory != null) {
            throw new IllegalStateException("BeanFactory can only be set once");
        }
        this.beanFactory = beanFactory;
    }

    public void begin() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory is not set");
        }
        this.fallback.begin();
    }

    public <T> T getObject(Class<T> clazz) {
        if (this.fallback.contains(clazz)) {
            return (T)this.fallback.getObject(clazz);
        }
        try {
            return (T)this.beanFactory.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return (T)this.fallback.getObject(clazz);
        }
    }

    public void end() {
        if (this.clearThreadLocalScope) {
            try {
                SpringThreadLocalScope threadLocalScope = (SpringThreadLocalScope)this.beanFactory.getBean(SpringThreadLocalScope.class);
                threadLocalScope.clear();
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        this.fallback.end();
    }
}

