/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.spring;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

class SpringThreadLocalScope
implements Scope {
    private final ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocalStringObjectMap();

    SpringThreadLocalScope() {
    }

    public void clear() {
        this.threadLocal.get().clear();
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        Map<String, Object> objects = this.threadLocal.get();
        if (!objects.containsKey(name)) {
            Object object = objectFactory.getObject();
            objects.put(name, object);
            return object;
        }
        return objects.get(name);
    }

    public Object remove(String name) {
        return this.threadLocal.get().remove(name);
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }

    static class ThreadLocalStringObjectMap
    extends ThreadLocal<Map<String, Object>> {
        ThreadLocalStringObjectMap() {
        }

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    }
}

