/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava;

import java.util.concurrent.atomic.AtomicReference;
import party.iroiro.luajava.AbstractLua;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.LuaJitNatives;
import party.iroiro.luajava.LuaNative;

public class LuaJit
extends AbstractLua {
    private static final AtomicReference<LuaJitNatives> natives = new AtomicReference();

    public LuaJit() throws LinkageError {
        super(LuaJit.getNatives());
    }

    protected LuaJit(long L, int id, AbstractLua main) {
        super(main.getLuaNative(), L, id, main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LuaNative getNatives() throws LinkageError {
        AtomicReference<LuaJitNatives> atomicReference = natives;
        synchronized (atomicReference) {
            if (natives.get() == null) {
                try {
                    natives.set(new LuaJitNatives());
                }
                catch (IllegalStateException e) {
                    throw new LinkageError("Unable to find natives or init", e);
                }
            }
            return natives.get();
        }
    }

    protected AbstractLua newThread(long L, int id, AbstractLua mainThread) {
        return new LuaJit(L, id, mainThread);
    }

    public Lua.LuaError convertError(int code) {
        switch (code) {
            case 0: {
                return Lua.LuaError.OK;
            }
            case 1: {
                return Lua.LuaError.YIELD;
            }
            case 2: {
                return Lua.LuaError.RUNTIME;
            }
            case 3: {
                return Lua.LuaError.SYNTAX;
            }
            case 4: {
                return Lua.LuaError.MEMORY;
            }
            case 5: {
                return Lua.LuaError.HANDLER;
            }
        }
        return null;
    }

    public Lua.LuaType convertType(int code) {
        switch (code) {
            case 1: {
                return Lua.LuaType.BOOLEAN;
            }
            case 6: {
                return Lua.LuaType.FUNCTION;
            }
            case 2: {
                return Lua.LuaType.LIGHTUSERDATA;
            }
            case 0: {
                return Lua.LuaType.NIL;
            }
            case -1: {
                return Lua.LuaType.NONE;
            }
            case 3: {
                return Lua.LuaType.NUMBER;
            }
            case 4: {
                return Lua.LuaType.STRING;
            }
            case 5: {
                return Lua.LuaType.TABLE;
            }
            case 8: {
                return Lua.LuaType.THREAD;
            }
            case 7: {
                return Lua.LuaType.USERDATA;
            }
        }
        return null;
    }
}

