package com.autodeal.dynamiclibrary;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ScrollView;

import com.autodeal.dynamiclibrary.model.ObjectClass;
import com.autodeal.dynamiclibrary.validator.ContentValidator;

import org.json.JSONException;

import java.util.ArrayList;

/**
 * Created by yragalvez on 05/12/2016.
 */

public class DynamicLayout {

    private Context mContext;
    private ArrayList<ObjectClass> arrObjects = new ArrayList<>();
    private ObjectCreator objectCreator;
    private JsonParser jsonParser = new JsonParser();
    private ContentValidator contentValidator;
    private Activity activity;

    public DynamicLayout(Context mContext){
        this.mContext = mContext;
        this.activity = (Activity) mContext;
        objectCreator = new ObjectCreator();
        contentValidator = new ContentValidator(activity);
    }

    private ArrayList<ObjectClass> parseJsonString(String jsonString) throws JSONException {
        arrObjects = new ArrayList<>();
        try {
            arrObjects.addAll(jsonParser.parseJsonString(jsonString));
        } catch (JSONException | NullPointerException e) {
            arrObjects = new ArrayList<>();
            e.printStackTrace();
        }
        return arrObjects;
    }

    public View setLayoutView(Context mContext, String jsonString){
        new DynamicLayout(mContext);
        try {
            parseJsonString(jsonString);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        objectCreator.initializeObjects(mContext, arrObjects);
        return objectCreator.LayoutView();
    }

    public void setLayoutView(Context mContext, String jsonString, View layout){
        new DynamicLayout(mContext);
        LinearLayout llBody = (LinearLayout) layout;
        try {
            parseJsonString(jsonString);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        objectCreator.initializeObjects(mContext, arrObjects);

        llBody.addView(objectCreator.LayoutView());
    }

    public ArrayList<ObjectClass> getComponents(){
        return contentValidator.getArrComponents();
    }

    public boolean validate(){
        contentValidator = new ContentValidator(activity);
        return contentValidator.ValidateFieldContents(arrObjects);
    }



}
