package com.autodeal.dynamiclibrary;

import com.autodeal.dynamiclibrary.model.ObjectClass;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by yragalvez on 07/12/2016.
 */

public class JsonParser {

    private ArrayList<ObjectClass> arrObjects = new ArrayList<>();

    public JsonParser(){}

    public ArrayList<ObjectClass> parseJsonString(String jsonString) throws JSONException {
        System.out.println("jsonparser " + jsonString);
        ArrayList<ObjectClass> arrayList = new ArrayList<>();
        ObjectClass objectClass = new ObjectClass();
        JSONObject jsonObject = new JSONObject(jsonString).getJSONObject("components");

        JSONArray arrComponents = jsonObject.names();
        for (int i = 0; i < jsonObject.length(); i++){
            JSONObject jsonComponents = jsonObject.getJSONObject(arrComponents.get(i).toString());

            String objType = jsonComponents.getString("type");
            String objDesc = jsonComponents.getString("label");
            int position = jsonComponents.getInt("position");

            if(objType.toLowerCase().contains("text") || objType.toLowerCase().contains("number") ||
                    objType.toLowerCase().contains("email")){

                String defaultValue = jsonComponents.getString("default_value");
                boolean isMultiline = jsonComponents.getBoolean("is_multiline");
                boolean isRequired = jsonComponents.getBoolean("required");
                if (objType.toLowerCase().contains("text"))
                    objType = "text";
                objectClass = new ObjectClass("EditText", objDesc, position, defaultValue, isRequired, isMultiline);
                objectClass.setInputType(objType);
            }
            else if(objType.equalsIgnoreCase("choice")){
                ArrayList<String> arrChoices = new ArrayList<>();
                boolean isRequired = jsonComponents.getBoolean("required");
                boolean isMultiValue = jsonComponents.getBoolean("is_multi_value");
                JSONObject objChoices = jsonComponents.getJSONObject("choices");
                JSONArray jArrChoices = objChoices.names();
                for (int y = 0; y < objChoices.length(); y++){
                    arrChoices.add(objChoices.getString(jArrChoices.getString(y)));
                }
                if (isMultiValue)
                    objectClass = new ObjectClass("CheckBox", objDesc, position, isRequired, arrChoices, isMultiValue);
                else {
                    if (arrChoices.size() > 2)
                        objectClass = new ObjectClass("Spinner", objDesc, position, isRequired, arrChoices, isMultiValue);
                    else
                        objectClass = new ObjectClass("RadioButton", objDesc, position, isRequired, arrChoices, isMultiValue);
                }
            }
            else if(objType.equalsIgnoreCase("Switch")){
                String defaultValue = jsonComponents.getString("default_value");
                objectClass = new ObjectClass("Switch", objDesc, position, defaultValue);
            }

            arrayList.add(objectClass);
        }
        sortObjByPosition(arrayList);
        return arrObjects;
    }

    private ArrayList<ObjectClass> sortObjByPosition(ArrayList<ObjectClass> arrObjList){
        arrObjects = new ArrayList<>();
        for (int i = 0; i < arrObjList.size(); i++){
            for (int j = 0; j <  arrObjList.size(); j++){
                if (arrObjList.get(j).getPosition() == i){
                    arrObjects.add(arrObjList.get(j));
                }
            }
        }
        return arrObjects;
    }
}
