package com.autodeal.dynamiclibrary;

import android.app.Activity;
import android.content.Context;
import android.support.design.widget.TextInputLayout;
import android.support.v4.content.ContextCompat;
import android.text.InputType;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;

import com.autodeal.dynamiclibrary.model.ObjectClass;
import com.autodeal.dynamiclibrary.utils.Util;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by yragalvez on 06/12/2016.
 */

public class ObjectCreator extends Activity {
    Util util = new Util();
    LinearLayout.LayoutParams params, llParams, rbParams, etParams, spnrParams;
    ScrollView scrollView;
    LinearLayout llBody;
    Context mContext;

    public void initializeObjects(Context mContext, ArrayList<ObjectClass> objectClass){
        this.mContext = mContext;
        scrollView = new ScrollView(mContext);
        scrollView.setFillViewport(true);
        llBody = new LinearLayout(mContext);
        llBody.setOrientation(LinearLayout.VERTICAL);
        int margin = util.convertDptoPx(mContext, 16);
        int rbMargin = util.convertDptoPx(mContext, 40);

        params = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        llParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        llParams.setMargins(margin, util.convertDptoPx(mContext, 8), margin, 0);
        rbParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        rbParams.setMargins(0, util.convertDptoPx(mContext, 8), rbMargin, 0);
        etParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        etParams.setMargins(0, util.convertDptoPx(mContext, 16), 0, util.convertDptoPx(mContext, 8));
        spnrParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        llBody.setLayoutParams(llParams);
        for (int i = 0; i < objectClass.size(); i++){
            CreateObject(objectClass.get(i));
        }
    }

    public ScrollView LayoutView(){
        scrollView.addView(llBody);
        return scrollView;
    }

    public void CreateObject(ObjectClass objectClass){
        switch (objectClass.getObjType()) {
            case "EditText":
                CreateEditText(objectClass);
                break;
            case "Button":
                CreateButton(objectClass);
                break;
            case "CheckBox":
                CreateCheckBox(objectClass);
                break;
            case "RadioButton":
                 CreateRadioButton(objectClass);
                break;
            case "TextView":
                CreateTextView(objectClass);
                break;
            case "Switch":
                CreateSwitch(objectClass);
                break;
            case "Spinner":
                CreateSpinner(objectClass);
                break;
            default:
                break;
        }
    }

    private void setAttributes(View view, ObjectClass objectClass){
        int _id = util.generateViewId();
        view.setId(_id);
        objectClass.setId(_id);
        view.setTag(objectClass.getObjDesc());
        if (objectClass.getObjType().equalsIgnoreCase("EditText"))
            view.setLayoutParams(etParams);
        else
            view.setLayoutParams(params);
    }

    private void CreateEditText(ObjectClass objectClass){
        final TextInputLayout textInputLayout = new TextInputLayout(mContext);
        textInputLayout.setHint(objectClass.getObjDesc());
        textInputLayout.setLayoutParams(params);
        textInputLayout.setHintTextAppearance(R.style.TextAppearence_App_TextInputLayout);
        final EditText editText = new EditText(mContext);
        setAttributes(editText, objectClass);

        if(util.isValueValid(objectClass.getInputType())){
            switch(objectClass.getInputType().toLowerCase()){
                case "number":
                    editText.setInputType(InputType.TYPE_CLASS_NUMBER);
                    break;
                case "email":
                    editText.setInputType(InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS);
                    break;
                case "text":
                    if (objectClass.getIsMultiLine()){
                        editText.setSingleLine(false);
                        editText.setLines(5);
                        editText.setMaxLines(10);
                        editText.setHorizontalScrollBarEnabled(false);
                        editText.setVerticalScrollBarEnabled(true);
                        editText.setGravity(Gravity.TOP);
                    }else{
                        editText.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_FLAG_CAP_SENTENCES);
                    }
                    break;
                default:
                    break;
            }
        }

        textInputLayout.setLayoutParams(params);
        textInputLayout.addView(editText);
        llBody.addView(textInputLayout);
    }

    private void CreateRadioButton(ObjectClass objectClass){
        final RadioGroup radioGroup = new RadioGroup(mContext);
        CreateTextViewLabel(objectClass);
        RadioButton radioButton;
        ArrayList<String> values = objectClass.getArrayList();
        for (int i = 0; i < values.size(); i++){
            radioButton = new RadioButton(mContext);
            radioButton.setText(values.get(i));
            radioButton.setPadding(0,0,util.convertDptoPx(mContext, 40),0);
            setAttributes(radioGroup, objectClass);
            radioButton.setLayoutParams(rbParams);
            radioGroup.addView(radioButton);
        }
        radioGroup.setOrientation(LinearLayout.HORIZONTAL);
        radioGroup.setLayoutParams(params);
        llBody.addView(radioGroup);
    }

    private void CreateTextView(ObjectClass objectClass){
        final TextView textView = new TextView(mContext);
        textView.setText(objectClass.getObjDesc());
        setAttributes(textView, objectClass);
        llBody.addView(textView);
    }

    private void CreateButton(ObjectClass objectClass){
        final Button button = new Button(mContext);
        button.setText(objectClass.getObjDesc());
        setAttributes(button, objectClass);
        llBody.addView(button);
    }

    private void CreateSwitch(ObjectClass objectClass){
        final Switch swSwitch = new Switch(mContext);
        swSwitch.setText(objectClass.getObjDesc());
        boolean switchStatus = objectClass.getDefaultValue().equalsIgnoreCase("true");
        swSwitch.setChecked(switchStatus);
        swSwitch.setPadding(0, util.convertDptoPx(mContext, 16), 0, util.convertDptoPx(mContext, 8));
        setAttributes(swSwitch, objectClass);
        llBody.addView(swSwitch);
    }

    private void CreateCheckBox(ObjectClass objectClass){
        CheckBox checkBox;
        CreateTextViewLabel(objectClass);
        for (int i = 0; i < objectClass.getArrayList().size(); i++){
            checkBox = new CheckBox(mContext);
            setAttributes(checkBox, objectClass);
            checkBox.setText(objectClass.getArrayList().get(i));
            llBody.addView(checkBox);
        }
    }

    private void CreateSpinner(ObjectClass objectClass){
        final Spinner spinner = new Spinner(mContext);

        CreateTextViewLabel(objectClass);
        List<String> dataValues = new ArrayList<>();
        dataValues.addAll(objectClass.getArrayList());

        SetSpinnerValues(spinner, dataValues);
        setAttributes(spinner, objectClass);
        spinner.setPadding(util.convertDptoPx(mContext, 24), util.convertDptoPx(mContext, 16), util.convertDptoPx(mContext, 16), util.convertDptoPx(mContext, 16));

        llBody.addView(spinner);
    }

    private void SetSpinnerValues(Spinner spinner, List<String>_result){
        List<String> accountTypeList = new ArrayList<>();
        accountTypeList.add(0, "--- SELECT ONE ---");
        for(int i = 1; i <= _result.size(); i++){
            accountTypeList.add(i, _result.get((i-1)));
        }
        ArrayAdapter<String> adpAccountType = new ArrayAdapter<>(mContext,
                android.R.layout.simple_spinner_item, accountTypeList);
        adpAccountType.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinner.setAdapter(adpAccountType);
    }

    private void CreateTextViewLabel(ObjectClass objectClass) {
        int labelId = util.generateViewId();
        final TextView textView = new TextView(mContext);
        textView.setId(labelId);
        objectClass.setLabelId(labelId);
        textView.setText(objectClass.getObjDesc());
        textView.setLayoutParams(params);
        textView.setTextColor(ContextCompat.getColor(mContext, R.color.primaryButton));
        textView.setClickable(true);
        textView.setFocusable(true);
        textView.setFocusableInTouchMode(true);
        llBody.addView(textView);
    }

}
