package com.autodeal.dynamiclibrary.model;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Created by yragalvez on 05/12/2016.
 */

public class ObjectClass implements Serializable{
    private int _id, position, drawable, labelId;
    private String objType, objDesc, defaultValue, bgColor, inputType, inputValue;
    private boolean isRequired, isMultiLine, isMultiValue;
    private ArrayList<String> arrayList;

    public ObjectClass(){}

    /* For Edittext*/
    public ObjectClass(int _id, String objType, String objDesc, int position, String defaultValue, boolean isRequired, boolean isMultiLine){
        this._id = _id;
        this.objType = objType;
        this.objDesc = objDesc;
        this.position = position;
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
        this.isMultiLine = isMultiLine;
    }

    public ObjectClass(String objType, String objDesc, int position, String defaultValue, boolean isRequired, boolean isMultiLine){
        this.objType = objType;
        this.objDesc = objDesc;
        this.position = position;
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
        this.isMultiLine = isMultiLine;
    }

    /* For objects with choices */
    public ObjectClass(int _id, String objType, String objDesc, int position, ArrayList<String> arrayList, boolean isRequired, boolean isMultiValue){
        this._id = _id;
        this.objType = objType;
        this.objDesc = objDesc;
        this.position = position;
        this.arrayList = new ArrayList<>();
        this.arrayList.addAll(arrayList);
        this.isRequired = isRequired;
        this.isMultiValue = isMultiValue;
    }

    public ObjectClass(String objType, String objDesc, int position, boolean isRequired, ArrayList<String> arrayList, boolean isMultiValue){
        this.objType = objType;
        this.objDesc = objDesc;
        this.position = position;
        this.arrayList = new ArrayList<>();
        this.arrayList.addAll(arrayList);
        this.isRequired = isRequired;
        this.isMultiValue = isMultiValue;
    }

    /* For Switches */
    public ObjectClass(int _id, String objType, String objDesc, int position, String defaultValue){
        this._id = _id;
        this.objType = objType;
        this.objDesc = objDesc;
        this.position = position;
        this.defaultValue = defaultValue;
    }

    public ObjectClass(String objType, String objDesc, int position, String defaultValue){
        this.objType = objType;
        this.objDesc = objDesc;
        this.position = position;
        this.defaultValue = defaultValue;
    }

    //Get Value
    public int getId(){return this._id;}
    public String getObjType(){return this.objType;}
    public String getObjDesc(){return this.objDesc;}
    public int getPosition(){return this.position;}
    public String getBgColor(){return this.bgColor;}
    public int getDrawable(){return this.drawable;}
    public String getDefaultValue(){return this.defaultValue;}
    public ArrayList<String> getArrayList(){return this.arrayList;}
    public String getInputType(){return this.inputType;}
    public boolean getIsRequired(){return this.isRequired;}
    public boolean getIsMultiLine(){return this.isMultiLine;}
    public boolean getIsMultiValue(){return this.isMultiValue;}
    public int getLabelId(){return this.labelId;}
    public String getInputValue(){return this.inputValue;}

    //Set Value
    public void setId(int _id){this._id = _id;}
    public void setObjType(String objType){this.objType = objType;}
    public void setObjDesc(String objDesc){this.objDesc = objDesc;}
    public void setPosition(int position){this.position = position;}
    public void setBgColor(String bgColor){this.bgColor = bgColor;}
    public void setDrawable(int drawable){this.drawable = drawable;}
    public void setDefaultValue(String defaultValue){this.defaultValue = defaultValue;}
    public void setArrayList(ArrayList<String> arrayList){this.arrayList = new ArrayList<>(); this.arrayList.addAll(arrayList);}
    public void setInputType(String inputType){this.inputType = inputType;}
    public void setIsRequired(boolean isRequired){this.isRequired = isRequired;}
    public void setIsMultiline(boolean isMultiLine){this.isMultiLine = isMultiLine;}
    public void setIsMultiValue(boolean isMultiValue){this.isMultiValue = isMultiValue;}
    public void setLabelId(int labelId){this.labelId = labelId;}
    public void setInputValue(String inputValue){this.inputValue = inputValue;}
}