package com.autodeal.dynamiclibrary.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.Patterns;
import android.util.TypedValue;
import android.view.View;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by yragalvez on 06/12/2016.
 */

public class Util {
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    public Util(){}

    public int generateViewId(){
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR1) {
            for (;;) {
                final int result = sNextGeneratedId.get();
                // aapt-generated IDs have the high byte nonzero; clamp to the range under that.
                int newValue = result + 1;
                if (newValue > 0x00FFFFFF)
                    newValue = 1; // Roll over to 1, not 0.
                if (sNextGeneratedId.compareAndSet(result, newValue)) {
                    return result;
                }
            }
        } else {
            return View.generateViewId();
        }
    }

    public int convertDptoPx(Context mContext, int dpMeasure){
        float scale = mContext.getResources().getDisplayMetrics().density;
        return (int) (dpMeasure * scale + 0.5f);
    }

    public boolean isValueValid(String input){
        return (input != null && !input.equalsIgnoreCase("null") && !input.equalsIgnoreCase(""));
    }

    public boolean isValidEmail(String email){
        String emailPattern = "[a-zA-Z0-9._-]+@[a-z]+\\.+[a-z]+";
        if (email == null || email.isEmpty())
            email = "";
        return email.trim().matches(emailPattern);
    }

    public boolean isValidName(String name){
        String namePattern = "^[a-zA-Z ]+$";
        if (name == null || name.isEmpty())
            name = "";
        System.out.println("isValidName " + name.trim().matches(namePattern));
        return name.trim().matches(namePattern);
    }

    public static String formatNumber(double decimal) {
        DecimalFormat decimalFormat = new DecimalFormat("#,###");
        return decimalFormat.format(decimal);
    }

    public static String formatPeso(double decimal) {
        return "P" + formatNumber(decimal);
    }

    public static String formatCalendarTime(Calendar calendar, String format) {
        if (format == null)
            format = "yyyy-MM-dd k:m:s";
        SimpleDateFormat _format = new SimpleDateFormat(format);
        return _format.format(calendar.getTime());
    }

    public static String formatDate(Date date) {
        return formatDate(date, null);
    }

    public static String formatDate(Date date, String format) {
        if (format == null)
            format = "yyyy-MM-dd k:m:s";
        SimpleDateFormat _format = new SimpleDateFormat(format);
        return _format.format(date.getTime());
    }
}
