package com.autodeal.dynamiclibrary.validator;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;

import com.autodeal.dynamiclibrary.model.ObjectClass;
import com.autodeal.dynamiclibrary.utils.Util;

import java.util.ArrayList;

/**
 * Created by yragalvez on 07/12/2016.
 */

public class ContentValidator {
    private Activity activity;
    private ArrayList<ObjectClass> arrComponents = new ArrayList<>();
    private Util util = new Util();

    public ContentValidator(Activity activity){
        this.activity = activity;
    }

    public boolean ValidateFieldContents(ArrayList<ObjectClass> arrObjects){
        boolean isValid = true;
        for (ObjectClass components : arrObjects){
            switch (components.getObjType()){
                case "EditText":
                    if (!validateEditText(components))
                        isValid = false;
                    break;
                case "RadioButton":
                    if (!validateRadioGroup(components))
                        isValid = false;
                    break;
                case "Spinner":
                    if (!validateSpinner(components))
                        isValid = false;
                    break;
                case "Switch":
                    if (!validateSwitch(components))
                        isValid = false;
                    break;
                }
        }
        return isValid;
    }

    private boolean validateEditText(ObjectClass component){
        EditText editText = (EditText) activity.findViewById(component.getId());
        String stringValue = editText.getText().toString();
        String etTag = editText.getTag().toString().toLowerCase();
        editText.setError(null);
        component.setInputValue(stringValue);
        arrComponents.add(component);
        if (editText.getTag().toString().toLowerCase().equals("email")){
            if(stringValue.equalsIgnoreCase("") || !util.isValidEmail(stringValue)){
                editText.setError("This email address is invalid.");
                return false;
            }
        }
        else if (!etTag.equalsIgnoreCase("username") && etTag.contains("name")){
            if (stringValue.equalsIgnoreCase("")){
                editText.setError(component.getObjDesc() + " is required.");
                return false;
            }
            else if (!util.isValidName(stringValue)){
                editText.setError("Must be from A-Z");
                return false;
            }
        }
        else if (stringValue.equalsIgnoreCase("")){
            editText.setError(component.getObjDesc() + " is required.");
            return false;
        }
        return true;
    }

    private boolean validateRadioGroup(ObjectClass component){
        RadioGroup radioGroup = (RadioGroup) activity.findViewById(component.getId());
        int radioButtonID = radioGroup.getCheckedRadioButtonId();
        View radioButton = radioGroup.findViewById(radioButtonID);
        int idx = radioGroup.indexOfChild(radioButton);

        if (component.getLabelId() > 0){
            TextView textView = (TextView) activity.findViewById(component.getLabelId());
            textView.setError(null);
            if (idx < 0){
                textView.setError("This field is required.");
                component.setInputValue("0");
                arrComponents.add(component);
                return false;
            }
            else{
                component.setInputValue(String.valueOf(idx));
                arrComponents.add(component);
            }
        }
        return true;
    }

    private boolean validateSpinner(ObjectClass component){
        Spinner spinner = (Spinner) activity.findViewById(component.getId());
        if (component.getLabelId() > 0){
            TextView textView = (TextView) activity.findViewById(component.getLabelId());
            textView.setError(null);
            int selectedItemId = spinner.getSelectedItemPosition() - 1;
            if (spinner.getSelectedItemId() <= 0){
                textView.setError("This field is required.");
                component.setInputValue(String.valueOf(selectedItemId));
                arrComponents.add(component);
                return false;
            }
            else{
                component.setInputValue(String.valueOf(selectedItemId));
                arrComponents.add(component);
            }
        }
        return true;
    }

    private boolean validateSwitch(ObjectClass component){
        Switch swSwitch = (Switch) activity.findViewById(component.getId());
        component.setInputValue(String.valueOf(swSwitch.isChecked()));
        arrComponents.add(component);
        return true;
    }

    public ArrayList<ObjectClass> getArrComponents(){
        return this.arrComponents;
    }
}
