/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.persistence.query;

import io.vertx.sqlclient.Tuple;
import java.util.UUID;
import ph.com.nightowlstudios.entity.Entity;
import ph.com.nightowlstudios.persistence.query.QueryBuilder;

public interface Query {
    public String sql();

    public Tuple tuple();

    public static QueryBuilder select(String fromTable) {
        return QueryBuilder.select(fromTable);
    }

    public static <T extends Entity> QueryBuilder select(Class<T> entityClass) {
        return QueryBuilder.select(entityClass);
    }

    public static QueryBuilder update(String table) {
        return QueryBuilder.update(table);
    }

    public static <T extends Entity> QueryBuilder update(Class<T> entityClass) {
        return QueryBuilder.update(entityClass);
    }

    public static QueryBuilder insert(String into) {
        return QueryBuilder.insert(into);
    }

    public static <T extends Entity> QueryBuilder insert(Class<T> entityClass) {
        return QueryBuilder.insert(entityClass);
    }

    public static QueryBuilder delete(String from) {
        return QueryBuilder.delete(from);
    }

    public static <T extends Entity> QueryBuilder delete(Class<T> from) {
        return QueryBuilder.delete(from);
    }

    public static Query select(String tableName, UUID id) {
        return Query.select(tableName).allColumns().where(id).build();
    }

    public static <T extends Entity> Query select(Class<T> entityClass, UUID id) {
        return Query.select(entityClass).allColumns().where(id).build();
    }

    public static <T extends Entity> Query insert(T entity) {
        return QueryBuilder.insert(entity);
    }

    public static <T extends Entity> Query update(T entity) {
        return QueryBuilder.update(entity);
    }

    public static <T extends Entity> Query delete(T entity) {
        return QueryBuilder.delete(entity);
    }
}

