/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.resource;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import ph.com.nightowlstudios.resource.Validator;

public class ValidationHandler {
    public static Handler<RoutingContext> create(String ... requiredParams) {
        return ctx -> {
            JsonObject body = ctx.getBodyAsJson();
            for (String param : requiredParams) {
                if (body.containsKey(param)) continue;
                ctx.fail(HttpResponseStatus.BAD_REQUEST.code());
                ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Missing required parameter");
                return;
            }
            ctx.next();
        };
    }

    public static Handler<RoutingContext> create(Validator<JsonObject> validator) {
        return ctx -> {
            JsonObject body = ctx.getBodyAsJson();
            if (!validator.predicate().test(body)) {
                ctx.fail(HttpResponseStatus.PRECONDITION_FAILED.code());
                ctx.response().setStatusCode(HttpResponseStatus.PRECONDITION_FAILED.code()).end(validator.errorMessage());
                return;
            }
            ctx.next();
        };
    }
}

