/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.ApplicationConfig;
import ph.com.nightowlstudios.resource.Resource;

public abstract class ApplicationVerticle<T extends ApplicationConfig>
extends AbstractVerticle {
    private final T appConfig;
    protected JWTAuth authProvider;
    private static final Logger log = LoggerFactory.getLogger(ApplicationVerticle.class);
    private static final Set<HttpMethod> ALLOWED_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.PUT, HttpMethod.POST, HttpMethod.PATCH, HttpMethod.DELETE, HttpMethod.OPTIONS));
    private static final Set<String> ALLOWED_HEADERS = new HashSet<String>(Arrays.asList(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.AUTHORIZATION.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS.toString(), HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString()));
    private static final Set<String> EXPOSED_HEADERS = new HashSet<String>(Collections.singletonList(HttpHeaders.AUTHORIZATION.toString()));
    static final String BANNER_TXT = "\n\u2593\u2588\u2588\u2588\u2588\u2588 \u2593\u2588\u2588\u2588\u2588\u2588\u2584   \u2584\u2588\u2588\u2588\u2588 \u2593\u2588\u2588\u2588\u2588\u2588    \n\u2593\u2588   \u2580 \u2592\u2588\u2588\u2580 \u2588\u2588\u258c \u2588\u2588\u2592 \u2580\u2588\u2592\u2593\u2588   \u2580    \n\u2592\u2588\u2588\u2588   \u2591\u2588\u2588   \u2588\u258c\u2592\u2588\u2588\u2591\u2584\u2584\u2584\u2591\u2592\u2588\u2588\u2588      \n\u2592\u2593\u2588  \u2584 \u2591\u2593\u2588\u2584   \u258c\u2591\u2593\u2588  \u2588\u2588\u2593\u2592\u2593\u2588  \u2584    \n\u2591\u2592\u2588\u2588\u2588\u2588\u2592\u2591\u2592\u2588\u2588\u2588\u2588\u2593 \u2591\u2592\u2593\u2588\u2588\u2588\u2580\u2592\u2591\u2592\u2588\u2588\u2588\u2588\u2592   \n\u2591\u2591 \u2592\u2591 \u2591 \u2592\u2592\u2593  \u2592  \u2591\u2592   \u2592 \u2591\u2591 \u2592\u2591 \u2591   \n \u2591 \u2591  \u2591 \u2591 \u2592  \u2592   \u2591   \u2591  \u2591 \u2591  \u2591   \n   \u2591    \u2591 \u2591  \u2591 \u2591 \u2591   \u2591    \u2591      \n   \u2591  \u2591   \u2591          \u2591    \u2591  \u2591   \n        \u2591                        \n";

    protected ApplicationVerticle(T appConfig) {
        this.appConfig = appConfig;
    }

    public void start(Promise<Void> startPromise) {
        Router rootRouter = Router.router((Vertx)this.vertx);
        this.onRootRouterCreate(rootRouter);
        rootRouter.route().handler((Handler)CorsHandler.create((String)this.appConfig.getAllowedOrigins()).allowCredentials(this.allowCORSCredentials()).allowedMethods(this.getAllowedMethods()).allowedHeaders(this.getAllowedHeaders()).exposedHeaders(this.getExposedHeaders()));
        rootRouter.route().handler((Handler)BodyHandler.create());
        this.authProvider = this.createAuthProvider();
        rootRouter.mountSubRouter(this.appConfig.getApiPrefix(), this.buildApiRouter(this.authProvider));
        rootRouter.mountSubRouter(this.appConfig.getWebSocketPrefix(), this.buildWebSocketRouter(this.authProvider));
        this.createHttpServer().requestHandler((Handler)rootRouter).listen(this.appConfig.getPort(), http -> {
            if (http.succeeded()) {
                startPromise.complete();
                log.info(this.appConfig.getBannerText());
                log.info("{} online at PORT: {}", (Object)this.appConfig.getApplicationName(), (Object)((HttpServer)http.result()).actualPort());
                this.onStart((HttpServer)http.result());
                return;
            }
            log.error("Error running server: " + http.cause());
            startPromise.fail(http.cause());
            this.onServerDeployFail(http.cause());
        });
    }

    protected T getAppConfig() {
        return this.appConfig;
    }

    protected JWTAuth getAuthProvider() {
        return this.authProvider;
    }

    protected void onRootRouterCreate(Router router) {
    }

    protected void apiRoutesSetup(Router router) {
    }

    protected void onStart(HttpServer httpServer) {
    }

    protected void onServerDeployFail(Throwable error) {
    }

    protected boolean allowCORSCredentials() {
        return true;
    }

    protected Set<HttpMethod> getAllowedMethods() {
        return ALLOWED_METHODS;
    }

    protected Set<String> getAllowedHeaders() {
        return ALLOWED_HEADERS;
    }

    protected Set<String> getExposedHeaders() {
        return EXPOSED_HEADERS;
    }

    protected Handler<RoutingContext> createRouteLogHandler() {
        return LoggerHandler.create();
    }

    protected Handler<RoutingContext> createRouteFailureHandler() {
        return ErrorHandler.create();
    }

    protected abstract JWTAuth createAuthProvider();

    protected abstract Class<Resource>[] getResourceClasses();

    private HttpServer createHttpServer() {
        if (this.appConfig.isProduction()) {
            return this.vertx.createHttpServer(this.createSSLHttpOptions());
        }
        return this.vertx.createHttpServer();
    }

    private HttpServerOptions createSSLHttpOptions() {
        JsonObject ssl = this.appConfig.getSSLConfig();
        HttpServerOptions options = new HttpServerOptions().setUseAlpn(false).setSsl(true);
        switch (ssl.getString("type", "")) {
            case "jks": {
                options.setKeyStoreOptions(new JksOptions().setPath(ssl.getString("path")).setPassword(ssl.getString("password")));
                break;
            }
            case "pfx": {
                options.setPfxKeyCertOptions(new PfxOptions().setPath(ssl.getString("path")).setPassword(ssl.getString("password")));
                break;
            }
            case "pem": {
                options.setPemKeyCertOptions(new PemKeyCertOptions().setKeyPath(ssl.getString("keyPath")).setCertPath(ssl.getString("certPath")));
            }
            default: {
                log.error("Missing SSL Configuration");
                throw new RuntimeException("No SSL Configuration Provided");
            }
        }
        return options;
    }

    private Router buildApiRouter(JWTAuth authProvider) throws RuntimeException {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler(this.createRouteLogHandler());
        router.route().failureHandler(this.createRouteFailureHandler());
        for (Class<Resource> controller : this.getResourceClasses()) {
            try {
                Resource resource = controller.getDeclaredConstructor(Router.class, JWTAuth.class).newInstance(router, authProvider);
            }
            catch (Exception e) {
                log.error("Unable to load {}. Error on {}. ", (Object)controller.getCanonicalName(), (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        this.apiRoutesSetup(router);
        return router;
    }

    private Router buildWebSocketRouter(JWTAuth authProvider) throws RuntimeException {
        SockJSHandler handler = SockJSHandler.create((Vertx)this.vertx);
        SockJSBridgeOptions options = new SockJSBridgeOptions();
        ArrayList<PermittedOptions> inbound = new ArrayList<PermittedOptions>(this.addInboundSocketRules());
        options.setInboundPermitted(inbound);
        ArrayList<PermittedOptions> outbound = new ArrayList<PermittedOptions>(this.addOutboundSocketRules());
        options.setOutboundPermitted(outbound);
        return handler.bridge(options);
    }

    protected List<PermittedOptions> addInboundSocketRules() {
        return new ArrayList<PermittedOptions>();
    }

    protected List<PermittedOptions> addOutboundSocketRules() {
        return new ArrayList<PermittedOptions>();
    }
}

