/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.service;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.service.ServiceUtils;

public abstract class Service
extends AbstractVerticle {
    private final Logger log;
    private final Map<String, Message<JsonObject>> messages = new HashMap<String, Message<JsonObject>>();

    public Service() {
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    public void start() throws Exception {
        this.setup(this.vertx);
        this.vertx.eventBus().consumer(((Object)((Object)this)).getClass().getName()).handler(message -> {
            String action = message.headers().get("action");
            try {
                JsonObject body = (JsonObject)message.body();
                this.messages.put(action, (Message<JsonObject>)message);
                Method method = ((Object)((Object)this)).getClass().getMethod(action, ServiceUtils.extractRequestPayloadParameterTypes(body));
                method.invoke((Object)this, ServiceUtils.extractRequestPayloadParameters(body));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.log.error(String.format("Error encountered upon handling of %s action on %s service.", action, ((Object)((Object)this)).getClass().getName()), e.getCause());
                message.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), e.getMessage());
            }
        });
        super.start();
    }

    protected abstract void setup(Vertx var1);

    protected <T> void reply(String action, T message) {
        Optional.ofNullable(this.messages.get(action)).ifPresent(m -> m.reply((Object)ServiceUtils.buildReplyPayload(message)));
        this.messages.remove(action);
    }

    protected void fail(String action, int code, String message) {
        Optional.ofNullable(this.messages.get(action)).ifPresent(m -> m.fail(code, message));
        this.messages.remove(action);
    }
}

