/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.repository;

import io.vertx.core.Future;
import io.vertx.sqlclient.Row;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collector;
import ph.com.nightowlstudios.entity.Entity;
import ph.com.nightowlstudios.persistence.PersistenceClient;
import ph.com.nightowlstudios.persistence.query.Query;
import ph.com.nightowlstudios.utils.Utils;

public abstract class Repository {
    private final PersistenceClient dbClient;

    public Repository() {
        this.dbClient = new PersistenceClient();
    }

    public Repository(PersistenceClient dbClient) {
        this.dbClient = dbClient;
    }

    protected PersistenceClient db() {
        return this.dbClient;
    }

    public <T extends Entity> Future<Optional<T>> findOneById(Class<T> entityClass, UUID id, Collector<Row, ?, List<T>> collector) {
        return this.db().query(Query.select(entityClass, id), collector).map(Utils::getFirstElement);
    }

    public <T extends Entity> Future<Optional<T>> findOneById(Class<T> entityClass, String id, Collector<Row, ?, List<T>> collector) {
        return this.findOneById(entityClass, UUID.fromString(id), collector);
    }
}

