/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.core;

import io.vertx.core.Vertx;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.service.Service;
import ph.com.nightowlstudios.service.ServiceBus;

public class Edge {
    private static final Logger logger = LoggerFactory.getLogger(Edge.class);
    private static final Set<String> registeredServices = new HashSet<String>();

    private Edge() {
    }

    public static <T extends Service> ServiceBus<T> serviceBus(Class<T> serviceClass) {
        if (registeredServices.contains(serviceClass.getName())) {
            return new ServiceBus<T>(serviceClass);
        }
        throw Edge.runtimeError(serviceClass);
    }

    public static <T extends Service> ServiceBus<T> serviceBus(Vertx vertx, Class<T> serviceClass) {
        if (registeredServices.contains(serviceClass.getName())) {
            return new ServiceBus<T>(vertx, serviceClass);
        }
        throw Edge.runtimeError(serviceClass);
    }

    static RuntimeException runtimeError(Class<?> serviceClass) {
        logger.error("Unknown {} service. Make sure the service has been registered.", (Object)serviceClass.getName());
        return new RuntimeException("Unknown Service");
    }

    static void registerService(Class<?> serviceClass) {
        registeredServices.add(serviceClass.getName());
    }
}

