/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.service;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import ph.com.nightowlstudios.entity.Table;

public class ServiceUtils {
    public static final String PAYLOAD = "payload";
    public static final String TYPE = "type";
    public static final String NIL_TYPE = "nil";

    private ServiceUtils() {
    }

    static JsonObject buildRequestPayload(Object ... payload) {
        JsonArray array = new JsonArray();
        JsonArray types = new JsonArray();
        Arrays.stream(payload).forEachOrdered(obj -> {
            if (ServiceUtils.isEntity(obj.getClass())) {
                array.add((Object)JsonObject.mapFrom((Object)obj));
                types.add((Object)obj.getClass().getName());
            } else if (obj.getClass().getName().equals(UUID.class.getName())) {
                array.add((Object)((UUID)obj).toString());
                types.add((Object)UUID.class.getName());
            } else {
                array.add(obj);
                types.add((Object)obj.getClass().getName());
            }
        });
        return new JsonObject().put(PAYLOAD, (Object)array).put(TYPE, (Object)types);
    }

    static <R> Optional<R> unwrapRequestResponse(JsonObject body) throws Exception {
        Object res;
        String typeName = body.getString(TYPE);
        Class<?> theClass = Class.forName(typeName);
        if (typeName.equalsIgnoreCase(NIL_TYPE)) {
            return Optional.empty();
        }
        if (ServiceUtils.isEntity(theClass)) {
            JsonObject payload = body.getJsonObject(PAYLOAD);
            res = Json.decodeValue((String)payload.encode(), theClass);
        } else {
            res = UUID.class.getName().equals(typeName) ? UUID.fromString(body.getString(PAYLOAD)) : (String.class.getName().equals(typeName) ? body.getString(PAYLOAD) : (Integer.class.getName().equals(typeName) ? body.getInteger(PAYLOAD) : (Long.class.getName().equals(typeName) ? body.getLong(PAYLOAD) : (Instant.class.getName().equals(typeName) ? body.getInstant(PAYLOAD) : (Double.class.getName().equals(typeName) ? body.getDouble(PAYLOAD) : (Float.class.getName().equals(typeName) ? body.getFloat(PAYLOAD) : (Number.class.getName().equals(typeName) ? body.getNumber(PAYLOAD) : (Buffer.class.getName().equals(typeName) ? body.getBuffer(PAYLOAD) : (Byte.class.getName().equals(typeName) ? (Object)body.getBinary(PAYLOAD) : body.getValue(PAYLOAD))))))))));
        }
        return Optional.ofNullable(theClass.cast(res));
    }

    static Object[] extractRequestPayloadParameters(JsonObject body) throws ClassNotFoundException {
        JsonArray payload = body.getJsonArray(PAYLOAD);
        JsonArray types = body.getJsonArray(TYPE);
        ArrayList<Object> args = new ArrayList<Object>();
        for (int pos = 0; pos < payload.size(); ++pos) {
            String className = types.getString(pos);
            Class<?> theClass = Class.forName(className);
            if (ServiceUtils.isEntity(theClass)) {
                args.add(Json.decodeValue((String)payload.getJsonObject(pos).encode(), theClass));
                continue;
            }
            if (UUID.class.getName().equals(className)) {
                args.add(UUID.fromString(payload.getString(pos)));
                continue;
            }
            if (String.class.getName().equals(className)) {
                args.add(payload.getString(pos));
                continue;
            }
            if (Integer.class.getName().equals(className)) {
                args.add(payload.getInteger(pos));
                continue;
            }
            if (Long.class.getName().equals(className)) {
                args.add(payload.getLong(pos));
                continue;
            }
            if (Instant.class.getName().equals(className)) {
                args.add(payload.getInstant(pos));
                continue;
            }
            if (Double.class.getName().equals(className)) {
                args.add(payload.getDouble(pos));
                continue;
            }
            if (Float.class.getName().equals(className)) {
                args.add(payload.getFloat(pos));
                continue;
            }
            if (Number.class.getName().equals(className)) {
                args.add(payload.getNumber(pos));
                continue;
            }
            if (Buffer.class.getName().equals(className)) {
                args.add(payload.getBuffer(pos));
                continue;
            }
            if (Byte.class.getName().equals(className)) {
                args.add(payload.getBinary(pos));
                continue;
            }
            args.add(payload.getValue(pos));
        }
        return args.toArray(new Object[0]);
    }

    static <T> boolean isEntity(Class<T> clasz) {
        return Arrays.stream(clasz.getDeclaredAnnotations()).anyMatch(a -> a.annotationType().getName().equals(Table.class.getName()));
    }

    static Class<?>[] extractRequestPayloadParameterTypes(JsonObject body) throws ClassNotFoundException {
        JsonArray types = body.getJsonArray(TYPE);
        ArrayList classes = new ArrayList();
        for (int i = 0; i < types.size(); ++i) {
            classes.add(Class.forName(types.getString(i)));
        }
        return classes.toArray(new Class[0]);
    }

    static <T> JsonObject buildReplyPayload(T message) {
        JsonObject payload = new JsonObject();
        if (message == null) {
            payload.put(PAYLOAD, (Object)"");
            payload.put(TYPE, (Object)NIL_TYPE);
        } else if (ServiceUtils.isEntity(message.getClass())) {
            payload.put(PAYLOAD, (Object)JsonObject.mapFrom(message));
            payload.put(TYPE, (Object)message.getClass().getName());
        } else if (message.getClass().getName().equals(UUID.class.getName())) {
            payload.put(PAYLOAD, (Object)((UUID)message).toString());
            payload.put(TYPE, (Object)UUID.class.getName());
        } else {
            payload.put(PAYLOAD, message);
            payload.put(TYPE, (Object)message.getClass().getName());
        }
        return payload;
    }
}

