package ph.com.nightowlstudios.entity;

import java.util.Arrays;

/**
 * @author <a href="mailto:josephharveyangeles@gmail.com">Joseph Harvey Angeles - <i>yev</i></a>
 * @since 4/17/21
 **/
public class EntityUtils {
  private EntityUtils() {}

  public static <T extends Entity> String getTableName(Class<T> entity) {
    return entity.getAnnotation(Table.class).value();
  }

  public static <T extends Entity> String[] getColumns(Class<T> clasz) {
    return Arrays
      .stream(clasz.getDeclaredFields())
      .filter(field -> field.isAnnotationPresent(Column.class))
      .map(field -> field.getDeclaredAnnotation(Column.class).value())
      .toArray(String[]::new);
  }
}
