/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.entity.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class LocalDateTimeDeserializer
extends StdDeserializer<LocalDateTime> {
    protected LocalDateTimeDeserializer() {
        this(LocalDateTime.class);
    }

    protected LocalDateTimeDeserializer(Class<?> vc) {
        super(vc);
    }

    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Instant instant;
        try {
            instant = Instant.ofEpochSecond(Long.parseLong(p.getText()));
        }
        catch (NumberFormatException e) {
            instant = Instant.parse(p.getText());
        }
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }
}

