/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.persistence.query;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import io.vertx.sqlclient.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import ph.com.nightowlstudios.entity.Column;
import ph.com.nightowlstudios.entity.Entity;
import ph.com.nightowlstudios.entity.Table;
import ph.com.nightowlstudios.persistence.query.Query;

public class QueryBuilder {
    private static final String WHITESPACE = " ";
    private final Map<QueryType, Function<String, String>> buildFuncs;
    private final List<Object> values;
    private final List<String> columns;
    private final List<OperatorEntry> ops;
    private final QueryType queryType;
    private final String tableName;
    private String whereColumn;
    private String whereOp;
    private Object whereValue;
    private String orderByColumn;
    private Sort sortBy = Sort.DESC;
    private String offset;
    private String limit;
    private String joinTableName;
    private String joinOnFromColumn;
    private String joinOnToColumn;
    private Join join;

    public QueryBuilder columns(String ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public QueryBuilder allColumns() {
        this.columns.clear();
        this.columns.add("*");
        return this;
    }

    public QueryBuilder set(String column, Object value) {
        this.columns.add(column);
        this.values.add(value);
        return this;
    }

    public QueryBuilder property(String column, Object value) {
        this.columns.add(column);
        this.values.add(value);
        return this;
    }

    public QueryBuilder where(String column, Object value) {
        this.whereColumn = column;
        this.whereOp = "=";
        this.whereValue = value;
        return this;
    }

    public QueryBuilder where(UUID id) {
        this.whereColumn = "id";
        this.whereOp = "=";
        this.whereValue = id;
        return this;
    }

    public QueryBuilder where(String column, String op, Object value) {
        this.whereColumn = column;
        this.whereOp = op;
        this.whereValue = value;
        return this;
    }

    public QueryBuilder and(String column, Object value) {
        this.ops.add(new OperatorEntry(LogicOperator.AND, column, value));
        return this;
    }

    public QueryBuilder and(String column, String op, Object value) {
        this.ops.add(new OperatorEntry(LogicOperator.AND, column, op, value));
        return this;
    }

    public QueryBuilder or(String column, Object value) {
        this.ops.add(new OperatorEntry(LogicOperator.OR, column, value));
        return this;
    }

    public QueryBuilder or(String column, String op, Object value) {
        this.ops.add(new OperatorEntry(LogicOperator.OR, column, op, value));
        return this;
    }

    public QueryBuilder innerJoin(String toTableName, String toColumn, String fromColumn) {
        return this.join(Join.INNER, toTableName, toColumn, fromColumn);
    }

    public <T extends Entity> QueryBuilder innerJoin(Class<T> toEntity, String toColumn, String fromColumn) {
        return this.join(Join.INNER, toEntity, toColumn, fromColumn);
    }

    public QueryBuilder fullJoin(String toTableName, String toColumn, String fromColumn) {
        return this.join(Join.FULL, toTableName, toColumn, fromColumn);
    }

    public <T extends Entity> QueryBuilder fullJoin(Class<T> toEntity, String toColumn, String fromColumn) {
        return this.join(Join.FULL, toEntity, toColumn, fromColumn);
    }

    public QueryBuilder fullOuterJoin(String toTableName, String toColumn, String fromColumn) {
        return this.join(Join.FULL_OUTER, toTableName, toColumn, fromColumn);
    }

    public <T extends Entity> QueryBuilder fullOuterJoin(Class<T> toEntity, String toColumn, String fromColumn) {
        return this.join(Join.FULL_OUTER, toEntity, toColumn, fromColumn);
    }

    public QueryBuilder leftJoin(String toTableName, String toColumn, String fromColumn) {
        return this.join(Join.LEFT, toTableName, toColumn, fromColumn);
    }

    public <T extends Entity> QueryBuilder leftJoin(Class<T> toEntity, String toColumn, String fromColumn) {
        return this.join(Join.LEFT, toEntity, toColumn, fromColumn);
    }

    public QueryBuilder rightJoin(String toTableName, String toColumn, String fromColumn) {
        return this.join(Join.RIGHT, toTableName, toColumn, fromColumn);
    }

    public <T extends Entity> QueryBuilder rightJoin(Class<T> toEntity, String toColumn, String fromColumn) {
        return this.join(Join.RIGHT, toEntity, toColumn, fromColumn);
    }

    private QueryBuilder join(Join join, String toTable, String toColumn, String fromColumn) {
        this.join = join;
        this.joinTableName = toTable;
        this.joinOnToColumn = toColumn;
        this.joinOnFromColumn = fromColumn;
        return this;
    }

    private <T extends Entity> QueryBuilder join(Join join, Class<T> toEntity, String toColumn, String fromColumn) {
        return this.join(join, QueryBuilder.toTableName(toEntity), toColumn, fromColumn);
    }

    public QueryBuilder orderBy(String column) {
        this.orderByColumn = column;
        return this;
    }

    public QueryBuilder descending() {
        this.sortBy = Sort.DESC;
        return this;
    }

    public QueryBuilder ascending() {
        this.sortBy = Sort.ASC;
        return this;
    }

    public QueryBuilder offset(String offset) {
        this.offset = offset;
        return this;
    }

    public QueryBuilder offset(int offset) {
        return this.offset(Integer.toString(offset, 10));
    }

    public QueryBuilder limit(String limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder limit(int limit) {
        return this.limit(Integer.toString(limit, 10));
    }

    public static QueryBuilder select(String tableName) {
        return new QueryBuilder(tableName, QueryType.SELECT);
    }

    public static <T extends Entity> QueryBuilder select(Class<T> tClass) {
        return new QueryBuilder(tClass, QueryType.SELECT);
    }

    public static QueryBuilder update(String tableName) {
        return new QueryBuilder(tableName, QueryType.UPDATE);
    }

    public static <T extends Entity> QueryBuilder update(Class<T> tClass) {
        return new QueryBuilder(tClass, QueryType.UPDATE);
    }

    public static QueryBuilder insert(String tableName) {
        return new QueryBuilder(tableName, QueryType.INSERT);
    }

    public static <T extends Entity> QueryBuilder insert(Class<T> tClass) {
        return new QueryBuilder(tClass, QueryType.INSERT);
    }

    public static QueryBuilder delete(String tableName) {
        return new QueryBuilder(tableName, QueryType.DELETE);
    }

    public static <T extends Entity> QueryBuilder delete(Class<T> tClass) {
        return new QueryBuilder(tClass, QueryType.DELETE);
    }

    public Query build() {
        String SQL = this.buildSQLStatement();
        if (StringUtils.isNotBlank((CharSequence)this.whereColumn)) {
            this.values.add(this.whereValue);
        }
        this.ops.forEach(op -> this.values.add(op.getValue()));
        return new QueryImpl(SQL, this.values);
    }

    private String buildSQLStatement() {
        StringBuilder SQL = new StringBuilder();
        SQL.append(this.buildFuncs.get((Object)this.queryType).apply(this.tableName).trim());
        if (this.join != null) {
            SQL.append(WHITESPACE);
            SQL.append(this.buildJoinClause());
        }
        if (StringUtils.isNotBlank((CharSequence)this.whereColumn)) {
            SQL.append(WHITESPACE);
            SQL.append(this.buildWhereClause().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderByColumn)) {
            SQL.append(WHITESPACE);
            SQL.append(this.buildOrderByClause().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.limit)) {
            SQL.append(WHITESPACE);
            SQL.append(this.buildOffsetLimit().trim());
        }
        return SQL.toString();
    }

    private String buildJoinClause() {
        if (this.join == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        switch (this.join) {
            case LEFT: {
                result.append("LEFT");
                break;
            }
            case RIGHT: {
                result.append("RIGHT");
                break;
            }
            case FULL: {
                result.append("FULL");
                break;
            }
            case FULL_OUTER: {
                result.append("FULL OUTER");
                break;
            }
            default: {
                result.append("INNER");
            }
        }
        String onColumns = String.format("%s.%s = %s.%s", this.tableName, this.joinOnFromColumn, this.joinTableName, this.joinOnToColumn);
        return result.append(" JOIN ").append(this.joinTableName).append(" ON ").append(onColumns).toString();
    }

    private String buildOrderByClause() {
        if (StringUtils.isNotBlank((CharSequence)this.orderByColumn)) {
            String sort = this.sortBy == Sort.ASC ? "ASC" : "DESC";
            return String.format("ORDER BY %s %s", this.orderByColumn, sort);
        }
        return "";
    }

    private String buildOffsetLimit() {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.offset)) {
            result.append("OFFSET").append(WHITESPACE).append(this.offset);
        }
        if (StringUtils.isNotBlank((CharSequence)this.limit)) {
            result.append(WHITESPACE).append("LIMIT").append(WHITESPACE).append(this.limit);
        }
        return result.toString();
    }

    public static <T extends Entity> Query insert(T entity) {
        return new QueryImpl(QueryBuilder.buildInsertSQL(QueryBuilder.toTableName(entity.getClass()), QueryBuilder.getColumns(entity.getClass())), QueryBuilder.toTuple(entity));
    }

    public static <T extends Entity> Query update(T entity) {
        String SQL = String.format("%s WHERE id='%s'", QueryBuilder.buildUpdateSQL(QueryBuilder.toTableName(entity.getClass()), QueryBuilder.getColumns(entity.getClass())), Try.of((CheckedFunction0 & Serializable)() -> entity.getClass().getDeclaredMethod("getId", new Class[0]).invoke((Object)entity, new Object[0])).getOrNull());
        return new QueryImpl(SQL, QueryBuilder.toTuple(entity));
    }

    public static <T extends Entity> Query delete(T entity) {
        Object uuid = Try.of((CheckedFunction0 & Serializable)() -> entity.getClass().getDeclaredMethod("getId", new Class[0]).invoke((Object)entity, new Object[0])).getOrNull();
        String SQL = String.format("DELETE FROM %s WHERE id=$1", QueryBuilder.toTableName(entity.getClass()));
        return new QueryImpl(SQL, Tuple.of((Object)uuid));
    }

    private String buildSelectSQL(String tableName) {
        String format = "%s %s FROM %s";
        String columns = StringUtils.join(this.columns, (String)",");
        return String.format(format, new Object[]{QueryType.SELECT, columns, tableName});
    }

    private String buildUpdateSQL(String tableName) {
        return QueryBuilder.buildUpdateSQL(tableName, this.columns.toArray(new String[0]));
    }

    private static String buildUpdateSQL(String tableName, String ... columns) {
        String format = "%s %s SET %s";
        String values = IntStream.rangeClosed(1, columns.length).mapToObj(i -> String.format("%s=$%d", columns[i - 1], i)).collect(Collectors.joining(", "));
        return String.format(format, new Object[]{QueryType.UPDATE, tableName, values});
    }

    private String buildDeleteSQL(String tableName) {
        return String.format("%s from %s", new Object[]{QueryType.DELETE, tableName});
    }

    private String buildInsertSQL(String tableName) {
        return QueryBuilder.buildInsertSQL(tableName, this.columns.toArray(new String[0]));
    }

    private static String buildInsertSQL(String tableName, String ... columns) {
        String format = "%s INTO %s (%s) VALUES (%s)";
        return String.format(format, new Object[]{QueryType.INSERT, tableName, String.join((CharSequence)",", columns), QueryBuilder.buildValuesForInsert(columns.length)});
    }

    private static String buildValuesForInsert(int size) {
        return IntStream.rangeClosed(1, size).mapToObj(i -> String.format("$%d", i)).collect(Collectors.joining(", "));
    }

    private String buildWhereClause() {
        if (this.whereColumn == null) {
            return "";
        }
        int startIndex = this.values.size() + 1;
        String logicals = IntStream.rangeClosed(1, this.ops.size()).mapToObj(i -> {
            OperatorEntry e = this.ops.get(i - 1);
            return String.format("%s %s%s$%d", new Object[]{e.getLogicOp(), e.getColumn(), e.getOperator(), i + startIndex});
        }).collect(Collectors.joining(WHITESPACE));
        return String.format("WHERE %s%s$%d %s", this.whereColumn, this.whereOp, startIndex, logicals).trim();
    }

    private static <T extends Entity> String toTableName(Class<T> clasz) {
        return clasz.getAnnotation(Table.class).value();
    }

    private static <T extends Entity> Tuple toTuple(T entity) {
        return Tuple.tuple(Arrays.stream(entity.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).map(field -> {
            String prefix = field.getType().equals(Boolean.TYPE) ? "is" : "get";
            return Try.of((CheckedFunction0 & Serializable)() -> entity.getClass().getDeclaredMethod(prefix + StringUtils.capitalize((String)field.getName()), new Class[0]).invoke((Object)entity, new Object[0])).getOrNull();
        }).collect(Collectors.toList()));
    }

    private static <T extends Entity> String[] getColumns(Class<T> clasz) {
        return (String[])Arrays.stream(clasz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).map(field -> field.getDeclaredAnnotation(Column.class).value()).toArray(String[]::new);
    }

    QueryBuilder(String tableName, QueryType queryType) {
        this.tableName = tableName;
        this.queryType = queryType;
        this.values = new ArrayList<Object>();
        this.columns = new ArrayList<String>();
        this.ops = new ArrayList<OperatorEntry>();
        this.buildFuncs = new HashMap<QueryType, Function<String, String>>();
        this.buildFuncs.put(QueryType.SELECT, this::buildSelectSQL);
        this.buildFuncs.put(QueryType.UPDATE, this::buildUpdateSQL);
        this.buildFuncs.put(QueryType.DELETE, this::buildDeleteSQL);
        this.buildFuncs.put(QueryType.INSERT, this::buildInsertSQL);
    }

    <T extends Entity> QueryBuilder(Class<T> tClass, QueryType queryType) {
        this(tClass.getAnnotation(Table.class).value(), queryType);
    }

    static final class QueryImpl
    implements Query {
        private final String sql;
        private final Tuple tuple;

        QueryImpl(String sql, Tuple tuple) {
            this.sql = sql;
            this.tuple = tuple;
        }

        QueryImpl(String sql, List<Object> values) {
            this(sql, Tuple.tuple(values));
        }

        @Override
        public String sql() {
            return this.sql;
        }

        @Override
        public Tuple tuple() {
            return this.tuple;
        }
    }

    static final class OperatorEntry {
        private final LogicOperator logicOp;
        private final String column;
        private final String op;
        private final Object value;

        OperatorEntry(LogicOperator logicOp, String column, Object value) {
            this.logicOp = logicOp;
            this.column = column;
            this.value = value;
            this.op = "=";
        }

        OperatorEntry(LogicOperator logicOp, String column, String op, Object value) {
            this.logicOp = logicOp;
            this.column = column;
            this.op = op;
            this.value = value;
        }

        LogicOperator getLogicOp() {
            return this.logicOp;
        }

        String getColumn() {
            return this.column;
        }

        String getOperator() {
            return this.op;
        }

        Object getValue() {
            return this.value;
        }
    }

    private static enum Join {
        INNER,
        LEFT,
        RIGHT,
        FULL,
        FULL_OUTER;

    }

    private static enum Sort {
        ASC,
        DESC;

    }

    private static enum LogicOperator {
        AND,
        OR;

    }

    private static enum QueryType {
        SELECT,
        INSERT,
        UPDATE,
        DELETE;

    }
}

