/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.repository;

import io.vertx.core.Future;
import io.vertx.sqlclient.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collector;
import ph.com.nightowlstudios.dto.DTO;
import ph.com.nightowlstudios.entity.Entity;
import ph.com.nightowlstudios.persistence.Collectors;
import ph.com.nightowlstudios.persistence.PersistenceClient;
import ph.com.nightowlstudios.persistence.query.Query;
import ph.com.nightowlstudios.utils.Utils;

public abstract class Repository {
    private final PersistenceClient dbClient;

    public Repository() {
        this.dbClient = new PersistenceClient();
    }

    public Repository(PersistenceClient dbClient) {
        this.dbClient = dbClient;
    }

    protected PersistenceClient db() {
        return this.dbClient;
    }

    public <T extends Entity> Future<Optional<T>> findOneById(Class<T> entityClass, UUID id) {
        return this.findOneById(entityClass, id, Collectors.ofEntities(entityClass));
    }

    public <T extends Entity> Future<Optional<T>> findOneById(Class<T> entityClass, String id) {
        return this.findOneById(entityClass, UUID.fromString(id), Collectors.ofEntities(entityClass));
    }

    public <T extends Entity> Future<Optional<T>> findOneById(Class<T> entityClass, UUID id, Collector<Row, ?, List<T>> collector) {
        return this.db().query(Query.select(entityClass, id), collector).map(Utils::getFirstElement);
    }

    protected <T extends DTO> Collector<Row, ?, List<T>> collectDto(Function<Row, T> convert) {
        return Collector.of(ArrayList::new, (list, row) -> list.add(convert.apply((Row)row)), (first, second) -> {
            first.addAll(second);
            return first;
        }, new Collector.Characteristics[0]);
    }
}

