/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.service;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import ph.com.nightowlstudios.dto.DTO;
import ph.com.nightowlstudios.entity.Table;

public class ServiceUtils {
    public static final String PAYLOAD = "payload";
    public static final String TYPE = "type";
    public static final String NIL_TYPE = "nil";

    private ServiceUtils() {
    }

    static JsonObject buildRequestPayload(Object ... payload) {
        JsonArray array = new JsonArray();
        JsonArray types = new JsonArray();
        Arrays.stream(payload).forEachOrdered(obj -> {
            if (ServiceUtils.isEntity(obj.getClass()) || ServiceUtils.isDTO(obj.getClass())) {
                array.add((Object)JsonObject.mapFrom((Object)obj));
                types.add((Object)obj.getClass().getName());
            } else if (obj.getClass().getName().equals(UUID.class.getName())) {
                array.add((Object)((UUID)obj).toString());
                types.add((Object)UUID.class.getName());
            } else {
                array.add(obj);
                types.add((Object)obj.getClass().getName());
            }
        });
        return new JsonObject().put(PAYLOAD, (Object)array).put(TYPE, (Object)types);
    }

    static <R> Optional<R> unwrapRequestResponse(JsonObject body) throws Exception {
        String typeName = body.getString(TYPE);
        return !typeName.equalsIgnoreCase(NIL_TYPE) ? Optional.ofNullable(Class.forName(typeName).cast(ServiceUtils.fromReplyPayload(body))) : Optional.empty();
    }

    private static Object fromReplyPayload(JsonObject body) throws Exception {
        String typeName = body.getString(TYPE);
        Class<?> theClass = Class.forName(typeName);
        if (ServiceUtils.isEntity(Class.forName(typeName)) || ServiceUtils.isDTO(Class.forName(typeName))) {
            JsonObject payload = body.getJsonObject(PAYLOAD);
            return payload.mapTo(theClass);
        }
        if (UUID.class.getName().equals(typeName)) {
            return UUID.fromString(body.getString(PAYLOAD));
        }
        if (String.class.getName().equals(typeName)) {
            return body.getString(PAYLOAD);
        }
        if (Integer.class.getName().equals(typeName)) {
            return body.getInteger(PAYLOAD);
        }
        if (Long.class.getName().equals(typeName)) {
            return body.getLong(PAYLOAD);
        }
        if (Instant.class.getName().equals(typeName)) {
            return body.getInstant(PAYLOAD);
        }
        if (Double.class.getName().equals(typeName)) {
            return body.getDouble(PAYLOAD);
        }
        if (Float.class.getName().equals(typeName)) {
            return body.getFloat(PAYLOAD);
        }
        if (Number.class.getName().equals(typeName)) {
            return body.getNumber(PAYLOAD);
        }
        if (Buffer.class.getName().equals(typeName)) {
            return body.getBuffer(PAYLOAD);
        }
        if (Byte.class.getName().equals(typeName)) {
            return body.getBinary(PAYLOAD);
        }
        if (typeName.toLowerCase().endsWith("list")) {
            ArrayList<Object> list = new ArrayList<Object>();
            JsonArray array = body.getJsonArray(PAYLOAD);
            for (int i = 0; i < array.size(); ++i) {
                list.add(ServiceUtils.fromReplyPayload(array.getJsonObject(i)));
            }
            return list;
        }
        return body.getValue(PAYLOAD);
    }

    static Object[] extractRequestPayloadParameters(JsonObject body) throws ClassNotFoundException {
        JsonArray payload = body.getJsonArray(PAYLOAD);
        JsonArray types = body.getJsonArray(TYPE);
        ArrayList<Object> args = new ArrayList<Object>();
        for (int pos = 0; pos < payload.size(); ++pos) {
            String className = types.getString(pos);
            Class<?> theClass = Class.forName(className);
            if (ServiceUtils.isEntity(theClass) || ServiceUtils.isDTO(theClass)) {
                args.add(payload.getJsonObject(pos).mapTo(theClass));
                continue;
            }
            if (UUID.class.getName().equals(className)) {
                args.add(UUID.fromString(payload.getString(pos)));
                continue;
            }
            if (String.class.getName().equals(className)) {
                args.add(payload.getString(pos));
                continue;
            }
            if (Integer.class.getName().equals(className)) {
                args.add(payload.getInteger(pos));
                continue;
            }
            if (Long.class.getName().equals(className)) {
                args.add(payload.getLong(pos));
                continue;
            }
            if (Instant.class.getName().equals(className)) {
                args.add(payload.getInstant(pos));
                continue;
            }
            if (Double.class.getName().equals(className)) {
                args.add(payload.getDouble(pos));
                continue;
            }
            if (Float.class.getName().equals(className)) {
                args.add(payload.getFloat(pos));
                continue;
            }
            if (Number.class.getName().equals(className)) {
                args.add(payload.getNumber(pos));
                continue;
            }
            if (Buffer.class.getName().equals(className)) {
                args.add(payload.getBuffer(pos));
                continue;
            }
            if (Byte.class.getName().equals(className)) {
                args.add(payload.getBinary(pos));
                continue;
            }
            args.add(payload.getValue(pos));
        }
        return args.toArray(new Object[0]);
    }

    static <T> boolean isEntity(Class<T> clasz) {
        return Arrays.stream(clasz.getDeclaredAnnotations()).anyMatch(a -> a.annotationType().getName().equals(Table.class.getName()));
    }

    static <T> boolean isDTO(Class<T> tClass) {
        return tClass.getSuperclass().getName().equals(DTO.class.getName());
    }

    static Class<?>[] extractRequestPayloadParameterTypes(JsonObject body) throws ClassNotFoundException {
        JsonArray types = body.getJsonArray(TYPE);
        ArrayList classes = new ArrayList();
        for (int i = 0; i < types.size(); ++i) {
            classes.add(Class.forName(types.getString(i)));
        }
        return classes.toArray(new Class[0]);
    }

    static <T> JsonObject buildReplyPayload(T message) {
        JsonObject payload = new JsonObject();
        payload.put(PAYLOAD, ServiceUtils.toReplyPayload(message));
        payload.put(TYPE, (Object)Optional.ofNullable(message).map(m -> m.getClass().getName()).orElse(NIL_TYPE));
        return payload;
    }

    private static Object toReplyPayload(Object object) {
        if (object == null) {
            return "";
        }
        if (ServiceUtils.isEntity(object.getClass()) || ServiceUtils.isDTO(object.getClass())) {
            return JsonObject.mapFrom((Object)object);
        }
        if (object.getClass().getName().equals(UUID.class.getName())) {
            return ((UUID)object).toString();
        }
        if (object.getClass().getName().toLowerCase().endsWith("list")) {
            List list = (List)object;
            JsonArray array = new JsonArray();
            list.forEach(item -> array.add((Object)ServiceUtils.buildReplyPayload(item)));
            return array;
        }
        return object;
    }
}

