/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.persistence;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Row;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.entity.Column;
import ph.com.nightowlstudios.entity.Entity;

public class Collectors {
    private static final Logger log = LoggerFactory.getLogger(Collectors.class);

    public static <T extends Entity> Collector<Row, ?, List<T>> ofEntities(Class<T> clasz) {
        return Collector.of(ArrayList::new, (list, row) -> list.add(Collectors.fromRow(row, clasz)), (first, second) -> {
            first.addAll(second);
            return first;
        }, new Collector.Characteristics[0]);
    }

    public static Collector<Row, ?, JsonArray> ofJsonObjects(String ... columnNames) {
        return Collector.of(JsonArray::new, (array, row) -> array.add((Object)Collectors.fromRow(row, columnNames)), (first, second) -> {
            first.addAll(second);
            return first;
        }, new Collector.Characteristics[0]);
    }

    public static <T extends Entity> T fromRow(Row row, Class<T> clasz) {
        Entity attempt = null;
        try {
            attempt = (Entity)clasz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("ERROR mapping Row to Entity: {}", (Object)e.getMessage());
            throw new RuntimeException(e.getCause());
        }
        Entity result = attempt;
        ((Stream)Arrays.stream(clasz.getDeclaredFields()).parallel()).filter(field -> field.isAnnotationPresent(Column.class)).forEach(field -> {
            Optional<Object> method = Optional.ofNullable(Try.of((CheckedFunction0 & Serializable)() -> clasz.getDeclaredMethod("set" + StringUtils.capitalize((String)field.getName()), field.getType())).getOrNull());
            if (!method.isPresent()) {
                return;
            }
            int pos = row.getColumnIndex(field.getDeclaredAnnotation(Column.class).value());
            if (pos >= 0) {
                Try.of((CheckedFunction0 & Serializable)() -> ((Method)method.get()).invoke((Object)result, row.get(field.getType(), pos)));
            }
        });
        return (T)result;
    }

    public static JsonObject fromRow(Row row, String ... columnNames) {
        JsonObject json = new JsonObject();
        for (String column : columnNames) {
            json.put(column, row.getValue(column));
        }
        return json;
    }
}

