/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.resource;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.auth.BasicAuthentication;
import ph.com.nightowlstudios.auth.UserRole;
import ph.com.nightowlstudios.dto.DTO;

public abstract class Resource {
    private final Logger logger;
    private final Router router;

    public Resource(Router router) {
        this.router = router;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger().info("Loading {}...", (Object)this.getClass().getCanonicalName());
        this.init();
        this.setUp();
        this.routes();
    }

    void init() {
    }

    protected void setUp() {
    }

    protected abstract void routes();

    protected Logger logger() {
        return this.logger;
    }

    protected Router router() {
        return this.router;
    }

    protected String getPathParam(RoutingContext ctx, String param) {
        return this.getPathParam(ctx, param, "");
    }

    protected String getPathParam(RoutingContext ctx, String param, String def) {
        return Optional.ofNullable(ctx.pathParam(param)).orElse(def);
    }

    protected String getRequestParam(RoutingContext ctx, String param) {
        return this.getRequestParam(ctx, param, "");
    }

    protected String getRequestParam(RoutingContext ctx, String param, String def) {
        return Optional.ofNullable(ctx.request().getParam(param)).orElse(def);
    }

    protected <T> T getAuthClaim(RoutingContext ctx, String key) {
        return (T)ctx.user().get(key);
    }

    protected <T> T getAuthClaim(RoutingContext ctx, String key, T def) {
        return (T)Optional.ofNullable(ctx.user().get(key)).orElse(def);
    }

    protected Route route(HttpMethod method, String path) {
        return this.router().route(method, path);
    }

    protected Route protectedRoute(HttpMethod method, String path) {
        return this.route(method, path).handler(BasicAuthentication.getInstance().createAuthNHandler());
    }

    protected Route protectedRoute(HttpMethod method, String path, UserRole role) {
        return this.router.route(method, path).handler(BasicAuthentication.getInstance().createAuthNHandler()).handler(BasicAuthentication.getInstance().createAuthZHandler(role));
    }

    protected Route get(String path) {
        return this.protectedRoute(HttpMethod.GET, path);
    }

    protected Route get(String path, UserRole role) {
        return this.protectedRoute(HttpMethod.GET, path, role);
    }

    protected Route put(String path) {
        return this.protectedRoute(HttpMethod.PUT, path);
    }

    protected Route put(String path, UserRole role) {
        return this.protectedRoute(HttpMethod.PUT, path, role);
    }

    protected Route post(String path) {
        return this.protectedRoute(HttpMethod.POST, path);
    }

    protected Route post(String path, UserRole role) {
        return this.protectedRoute(HttpMethod.POST, path, role);
    }

    protected Route delete(String path) {
        return this.protectedRoute(HttpMethod.DELETE, path);
    }

    protected Route delete(String path, UserRole role) {
        return this.protectedRoute(HttpMethod.DELETE, path, role);
    }

    protected void endContext(RoutingContext ctx, HttpResponseStatus status, String message) {
        ctx.response().setStatusCode(status.code()).end(message);
    }

    protected void endContext(RoutingContext ctx, HttpResponseStatus status) {
        ctx.response().setStatusCode(status.code()).end(status.reasonPhrase());
    }

    protected void endContext(RoutingContext ctx, Object body) {
        ctx.response().setStatusCode(HttpResponseStatus.OK.code()).end(JsonObject.mapFrom((Object)body).encode());
    }

    protected void endContext(RoutingContext ctx, JsonObject body) {
        ctx.response().setStatusCode(HttpResponseStatus.OK.code()).end(body.encode());
    }

    protected void endContext(RoutingContext ctx, JsonArray body) {
        ctx.response().setStatusCode(HttpResponseStatus.OK.code()).end(body.encode());
    }

    protected <T extends DTO> void endContext(RoutingContext ctx, List<T> list) {
        JsonArray body = new JsonArray();
        list.forEach(dto -> body.add((Object)dto.toJson()));
        this.endContext(ctx, body);
    }

    protected <T> void on(RoutingContext ctx, Future<T> action, Handler<T> onSuccess) {
        action.onSuccess(onSuccess).onFailure(error -> this.failureHandler(ctx, (Throwable)error));
    }

    protected <T> Future<T> on(RoutingContext ctx, Future<T> action) {
        return action.onFailure(error -> this.failureHandler(ctx, (Throwable)error));
    }

    protected void failureHandler(RoutingContext ctx, Throwable cause) {
        if (cause instanceof IllegalArgumentException) {
            ctx.fail(HttpResponseStatus.BAD_REQUEST.code(), cause);
            return;
        }
        if (cause instanceof NullPointerException) {
            ctx.fail(HttpResponseStatus.NOT_FOUND.code(), cause);
            return;
        }
        if (cause instanceof IllegalAccessException || cause instanceof IllegalAccessError || cause instanceof SecurityException) {
            ctx.fail(HttpResponseStatus.FORBIDDEN.code(), cause);
            return;
        }
        ctx.fail(cause.getCause());
    }
}

