/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.entity;

import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import ph.com.nightowlstudios.entity.Column;
import ph.com.nightowlstudios.entity.Table;
import ph.com.nightowlstudios.utils.Utils;

public interface Entity {
    public static <T extends Entity> String getTableName(Class<T> entity) {
        return entity.getAnnotation(Table.class).value();
    }

    public static <T extends Entity> String[] getColumns(Class<T> clasz) {
        return (String[])Arrays.stream(clasz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).map(field -> field.getDeclaredAnnotation(Column.class).value()).toArray(String[]::new);
    }

    public static <T extends Entity> JsonObject toJson(T entity) {
        return Utils.camelCaseKeys(JsonObject.mapFrom(entity));
    }

    public static <T extends Entity> T fromJson(JsonObject json, Class<T> entityClass) {
        return (T)((Entity)Utils.camelCaseKeys(json).mapTo(entityClass));
    }
}

