/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.service;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.service.ServiceUtils;

public abstract class Service
extends AbstractVerticle {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void start() throws Exception {
        this.setup(this.vertx);
        this.vertx.eventBus().consumer(((Object)((Object)this)).getClass().getName()).handler(message -> {
            String action = message.headers().get("action");
            try {
                JsonObject body = (JsonObject)message.body();
                Method method = ((Object)((Object)this)).getClass().getMethod(action, ServiceUtils.extractRequestPayloadParameterTypes(body));
                Future response = (Future)method.invoke((Object)this, ServiceUtils.extractRequestPayloadParameters(body));
                response.onSuccess(payload -> {
                    if (payload == null || !payload.getClass().getName().equals(Void.class.getName())) {
                        message.reply((Object)ServiceUtils.buildReplyPayload(payload));
                    }
                }).onFailure(failure -> message.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), failure.getMessage()));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.log.error(String.format("Error encountered upon handling of %s action on %s service.", action, ((Object)((Object)this)).getClass().getName()), e.getCause());
                message.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), e.getMessage());
            }
        });
        super.start();
    }

    protected abstract void setup(Vertx var1);
}

