/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.persistence.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import ph.com.nightowlstudios.entity.Entity;
import ph.com.nightowlstudios.persistence.query.Query;

public class JoinSelectQueryBuilder {
    private final String tableName;
    private List<String> columns;
    private String whereColumn;
    private String whereOp;
    private Object whereValue;
    private List<String> logicals;

    <T extends Entity> JoinSelectQueryBuilder(Class<T> fromTable) {
        this(Entity.getTableName(fromTable));
    }

    JoinSelectQueryBuilder(String fromTable) {
        this.tableName = fromTable;
    }

    public JoinSelectQueryBuilder column(String ... columns) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public JoinSelectQueryBuilder where(String column, Object value) {
        this.whereColumn = column;
        this.whereOp = "=";
        this.whereValue = value.toString();
        return this;
    }

    public JoinSelectQueryBuilder where(String column, String op, Object value) {
        this.whereColumn = column;
        this.whereOp = op;
        this.whereValue = value.toString();
        return this;
    }

    public JoinSelectQueryBuilder and(String column, Object value) {
        return this.and(column, "=", value);
    }

    public JoinSelectQueryBuilder and(String column, String op, Object value) {
        return this.addLogical("AND", column, op, value);
    }

    public JoinSelectQueryBuilder or(String column, Object value) {
        return this.or(column, "=", value);
    }

    public JoinSelectQueryBuilder or(String column, String op, Object value) {
        return this.addLogical("OR", column, op, value);
    }

    private JoinSelectQueryBuilder addLogical(String logicOp, String column, String op, Object value) {
        if (this.logicals == null) {
            this.logicals = new ArrayList<String>();
        }
        this.logicals.add(String.format("%s %s %s '%s'", logicOp, column, op, value.toString()).trim());
        return this;
    }

    String build() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ").append(StringUtils.join(this.columns, (String)",")).append(String.format(" FROM %s", this.tableName));
        if (StringUtils.isNotEmpty((CharSequence)this.whereColumn)) {
            query.append(String.format(" WHERE %s %s '%s'", this.whereColumn, this.whereOp, this.whereValue));
            if (this.logicals != null) {
                this.logicals.forEach(line -> query.append(" ").append((String)line).append(" "));
            }
        }
        Object[] groupColumns = (String[])this.columns.stream().filter(column -> !column.contains("(")).map(column -> {
            String[] tokens = column.split(" ");
            if (tokens.length >= 1) {
                return tokens[0].trim();
            }
            return column.trim();
        }).toArray(String[]::new);
        return query.append(" GROUP BY ").append(StringUtils.join((Object[])groupColumns, (String)",")).toString().trim();
    }

    public static void main(String[] args) {
        String build = Query.joinSelect("public.likes").column("target_id", "user_id").where("user_id", "rando").build();
        System.out.println(build);
    }
}

