/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.resource.Resource;

public abstract class ApplicationVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(ApplicationVerticle.class);
    private static final Set<HttpMethod> ALLOWED_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.PUT, HttpMethod.POST, HttpMethod.PATCH, HttpMethod.DELETE, HttpMethod.OPTIONS));
    private static final Set<String> ALLOWED_HEADERS = new HashSet<String>(Arrays.asList(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.AUTHORIZATION.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS.toString(), HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString()));
    private static final Set<String> EXPOSED_HEADERS = new HashSet<String>(Collections.singletonList(HttpHeaders.AUTHORIZATION.toString()));
    static final String BANNER_TXT = "\n\u2593\u2588\u2588\u2588\u2588\u2588 \u2593\u2588\u2588\u2588\u2588\u2588\u2584   \u2584\u2588\u2588\u2588\u2588 \u2593\u2588\u2588\u2588\u2588\u2588    \n\u2593\u2588   \u2580 \u2592\u2588\u2588\u2580 \u2588\u2588\u258c \u2588\u2588\u2592 \u2580\u2588\u2592\u2593\u2588   \u2580    \n\u2592\u2588\u2588\u2588   \u2591\u2588\u2588   \u2588\u258c\u2592\u2588\u2588\u2591\u2584\u2584\u2584\u2591\u2592\u2588\u2588\u2588      \n\u2592\u2593\u2588  \u2584 \u2591\u2593\u2588\u2584   \u258c\u2591\u2593\u2588  \u2588\u2588\u2593\u2592\u2593\u2588  \u2584    \n\u2591\u2592\u2588\u2588\u2588\u2588\u2592\u2591\u2592\u2588\u2588\u2588\u2588\u2593 \u2591\u2592\u2593\u2588\u2588\u2588\u2580\u2592\u2591\u2592\u2588\u2588\u2588\u2588\u2592   \n\u2591\u2591 \u2592\u2591 \u2591 \u2592\u2592\u2593  \u2592  \u2591\u2592   \u2592 \u2591\u2591 \u2592\u2591 \u2591   \n \u2591 \u2591  \u2591 \u2591 \u2592  \u2592   \u2591   \u2591  \u2591 \u2591  \u2591   \n   \u2591    \u2591 \u2591  \u2591 \u2591 \u2591   \u2591    \u2591      \n   \u2591  \u2591   \u2591          \u2591    \u2591  \u2591   \n        \u2591                        \n";

    public void start(Promise<Void> startPromise) {
        Router rootRouter = Router.router((Vertx)this.vertx);
        this.beforeRouterCreate(rootRouter);
        rootRouter.route().handler((Handler)CorsHandler.create((String)this.allowedOrigins()).allowCredentials(this.allowCORSCredentials()).allowedMethods(this.allowedMethods()).allowedHeaders(this.allowedHeaders()).exposedHeaders(this.exposedHeaders()));
        rootRouter.route().handler((Handler)BodyHandler.create());
        rootRouter.mountSubRouter(this.apiPrefix(), this.createApiRouter());
        rootRouter.mountSubRouter(this.webSocketPrefix(), this.createWebSocketRouter());
        this.createHttpServer().requestHandler((Handler)rootRouter).listen(this.getPort(), http -> {
            if (http.succeeded()) {
                startPromise.complete();
                log.info(this.bannerText());
                log.info("{} online at PORT: {}", (Object)this.appName(), (Object)((HttpServer)http.result()).actualPort());
                this.onStart((HttpServer)http.result());
                return;
            }
            log.error("Error running server: " + http.cause());
            startPromise.fail(http.cause());
            this.onStartFail(http.cause());
        });
    }

    protected void beforeRouterCreate(Router router) {
    }

    protected void setupRoutes(Router apiRouter) {
    }

    protected void onStart(HttpServer httpServer) {
    }

    protected void onStartFail(Throwable error) {
    }

    protected int getPort() {
        return this.config().getInteger("port", Integer.valueOf(8888));
    }

    protected String appName() {
        return this.config().getString("name", "edge.api");
    }

    protected String version() {
        return this.config().getString("version", "1.0");
    }

    protected boolean allowCORSCredentials() {
        return true;
    }

    protected Set<HttpMethod> allowedMethods() {
        return ALLOWED_METHODS;
    }

    protected Set<String> allowedHeaders() {
        return ALLOWED_HEADERS;
    }

    protected Set<String> exposedHeaders() {
        return EXPOSED_HEADERS;
    }

    protected String allowedOrigins() {
        return this.config().getString("allowedOrigins", "*");
    }

    protected String apiPrefix() {
        return this.config().getString("apiPrefix", "api");
    }

    protected String webSocketPrefix() {
        return this.config().getString("wsPrefix", "ws");
    }

    protected String bannerText() {
        return BANNER_TXT;
    }

    protected boolean isProduction() {
        Predicate<String> isProdEnv = value -> value.equalsIgnoreCase("prod") || value.equalsIgnoreCase("production");
        if (StringUtils.isEmpty((CharSequence)this.config().getString("env", ""))) {
            return isProdEnv.test(Optional.ofNullable(System.getenv("env")).orElse("prod"));
        }
        return isProdEnv.test(this.config().getString("env"));
    }

    protected JsonObject sslConfig() {
        return this.config().getJsonObject("ssl", new JsonObject());
    }

    protected Handler<RoutingContext> createRouteLogHandler() {
        return LoggerHandler.create();
    }

    protected Handler<RoutingContext> createRouteFailureHandler() {
        return ErrorHandler.create((Vertx)this.getVertx());
    }

    protected abstract <R extends Resource> Class<R>[] getResourceClasses();

    private HttpServer createHttpServer() {
        if (this.isProduction() && !this.sslConfig().isEmpty()) {
            return this.vertx.createHttpServer(this.createSSLHttpOptions());
        }
        return this.vertx.createHttpServer();
    }

    private HttpServerOptions createSSLHttpOptions() {
        JsonObject ssl = this.sslConfig();
        HttpServerOptions options = new HttpServerOptions().setUseAlpn(false).setSsl(true);
        switch (ssl.getString("type", "")) {
            case "jks": {
                options.setKeyStoreOptions(new JksOptions().setPath(ssl.getString("path")).setPassword(ssl.getString("password")));
                break;
            }
            case "pfx": {
                options.setPfxKeyCertOptions(new PfxOptions().setPath(ssl.getString("path")).setPassword(ssl.getString("password")));
                break;
            }
            case "pem": {
                options.setPemKeyCertOptions(new PemKeyCertOptions().setKeyPath(ssl.getString("keyPath")).setCertPath(ssl.getString("certPath")));
            }
            default: {
                log.error("Missing SSL Configuration");
                throw new RuntimeException("No SSL Configuration Provided");
            }
        }
        return options;
    }

    private Router createApiRouter() throws RuntimeException {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler(this.createRouteLogHandler());
        router.route().failureHandler(this.createRouteFailureHandler());
        for (Class controller : this.getResourceClasses()) {
            try {
                controller.getDeclaredConstructor(Router.class).newInstance(router);
            }
            catch (Exception e) {
                log.error("Unable to load {}. Error on {}. ", (Object)controller.getCanonicalName(), (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        this.setupRoutes(router);
        return router;
    }

    private Router createWebSocketRouter() throws RuntimeException {
        SockJSHandler handler = SockJSHandler.create((Vertx)this.vertx);
        SockJSBridgeOptions options = new SockJSBridgeOptions();
        ArrayList<PermittedOptions> inbound = new ArrayList<PermittedOptions>(this.addInboundSocketRules());
        options.setInboundPermitteds(inbound);
        ArrayList<PermittedOptions> outbound = new ArrayList<PermittedOptions>(this.addOutboundSocketRules());
        options.setOutboundPermitteds(outbound);
        return handler.bridge(options);
    }

    protected List<PermittedOptions> addInboundSocketRules() {
        return new ArrayList<PermittedOptions>();
    }

    protected List<PermittedOptions> addOutboundSocketRules() {
        return new ArrayList<PermittedOptions>();
    }
}

